// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Settings for the operating system disk of the virtual machine.
 */
@Fluent
public final class OSDisk implements JsonSerializable<OSDisk> {
    /*
     * Specifies the ephemeral Disk Settings for the operating system disk used by the virtual machine.
     */
    private DiffDiskSettings ephemeralOSDiskSettings;

    /*
     * The type of caching to enable for the disk.
     */
    private CachingType caching;

    /*
     * The managedDisk property.
     */
    private ManagedDisk managedDisk;

    /*
     * The initial disk size in GB when creating new OS disk.
     */
    private Integer diskSizeGB;

    /*
     * Specifies whether writeAccelerator should be enabled or disabled on the disk.
     */
    private Boolean writeAcceleratorEnabled;

    /**
     * Creates an instance of OSDisk class.
     */
    public OSDisk() {
    }

    /**
     * Get the ephemeralOSDiskSettings property: Specifies the ephemeral Disk Settings for the operating system disk
     * used by the virtual machine.
     * 
     * @return the ephemeralOSDiskSettings value.
     */
    public DiffDiskSettings ephemeralOSDiskSettings() {
        return this.ephemeralOSDiskSettings;
    }

    /**
     * Set the ephemeralOSDiskSettings property: Specifies the ephemeral Disk Settings for the operating system disk
     * used by the virtual machine.
     * 
     * @param ephemeralOSDiskSettings the ephemeralOSDiskSettings value to set.
     * @return the OSDisk object itself.
     */
    public OSDisk withEphemeralOSDiskSettings(DiffDiskSettings ephemeralOSDiskSettings) {
        this.ephemeralOSDiskSettings = ephemeralOSDiskSettings;
        return this;
    }

    /**
     * Get the caching property: The type of caching to enable for the disk.
     * 
     * @return the caching value.
     */
    public CachingType caching() {
        return this.caching;
    }

    /**
     * Set the caching property: The type of caching to enable for the disk.
     * 
     * @param caching the caching value to set.
     * @return the OSDisk object itself.
     */
    public OSDisk withCaching(CachingType caching) {
        this.caching = caching;
        return this;
    }

    /**
     * Get the managedDisk property: The managedDisk property.
     * 
     * @return the managedDisk value.
     */
    public ManagedDisk managedDisk() {
        return this.managedDisk;
    }

    /**
     * Set the managedDisk property: The managedDisk property.
     * 
     * @param managedDisk the managedDisk value to set.
     * @return the OSDisk object itself.
     */
    public OSDisk withManagedDisk(ManagedDisk managedDisk) {
        this.managedDisk = managedDisk;
        return this;
    }

    /**
     * Get the diskSizeGB property: The initial disk size in GB when creating new OS disk.
     * 
     * @return the diskSizeGB value.
     */
    public Integer diskSizeGB() {
        return this.diskSizeGB;
    }

    /**
     * Set the diskSizeGB property: The initial disk size in GB when creating new OS disk.
     * 
     * @param diskSizeGB the diskSizeGB value to set.
     * @return the OSDisk object itself.
     */
    public OSDisk withDiskSizeGB(Integer diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return this;
    }

    /**
     * Get the writeAcceleratorEnabled property: Specifies whether writeAccelerator should be enabled or disabled on the
     * disk.
     * 
     * @return the writeAcceleratorEnabled value.
     */
    public Boolean writeAcceleratorEnabled() {
        return this.writeAcceleratorEnabled;
    }

    /**
     * Set the writeAcceleratorEnabled property: Specifies whether writeAccelerator should be enabled or disabled on the
     * disk.
     * 
     * @param writeAcceleratorEnabled the writeAcceleratorEnabled value to set.
     * @return the OSDisk object itself.
     */
    public OSDisk withWriteAcceleratorEnabled(Boolean writeAcceleratorEnabled) {
        this.writeAcceleratorEnabled = writeAcceleratorEnabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (ephemeralOSDiskSettings() != null) {
            ephemeralOSDiskSettings().validate();
        }
        if (managedDisk() != null) {
            managedDisk().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("ephemeralOSDiskSettings", this.ephemeralOSDiskSettings);
        jsonWriter.writeStringField("caching", this.caching == null ? null : this.caching.toString());
        jsonWriter.writeJsonField("managedDisk", this.managedDisk);
        jsonWriter.writeNumberField("diskSizeGB", this.diskSizeGB);
        jsonWriter.writeBooleanField("writeAcceleratorEnabled", this.writeAcceleratorEnabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OSDisk from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OSDisk if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IOException If an error occurs while reading the OSDisk.
     */
    public static OSDisk fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OSDisk deserializedOSDisk = new OSDisk();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("ephemeralOSDiskSettings".equals(fieldName)) {
                    deserializedOSDisk.ephemeralOSDiskSettings = DiffDiskSettings.fromJson(reader);
                } else if ("caching".equals(fieldName)) {
                    deserializedOSDisk.caching = CachingType.fromString(reader.getString());
                } else if ("managedDisk".equals(fieldName)) {
                    deserializedOSDisk.managedDisk = ManagedDisk.fromJson(reader);
                } else if ("diskSizeGB".equals(fieldName)) {
                    deserializedOSDisk.diskSizeGB = reader.getNullable(JsonReader::getInt);
                } else if ("writeAcceleratorEnabled".equals(fieldName)) {
                    deserializedOSDisk.writeAcceleratorEnabled = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOSDisk;
        });
    }
}
