// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.resourcemanager.batch.fluent.models.PrivateLinkResourceInner;
import java.util.List;
import java.util.Map;

/**
 * An immutable client-side representation of PrivateLinkResource.
 */
public interface PrivateLinkResource {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the etag property: The ETag of the resource, used for concurrency statements.
     * 
     * @return the etag value.
     */
    String etag();

    /**
     * Gets the tags property: The tags of the resource.
     * 
     * @return the tags value.
     */
    Map<String, String> tags();

    /**
     * Gets the groupId property: The group id is used to establish the private link connection.
     * 
     * @return the groupId value.
     */
    String groupId();

    /**
     * Gets the requiredMembers property: The list of required members that are used to establish the private link
     * connection.
     * 
     * @return the requiredMembers value.
     */
    List<String> requiredMembers();

    /**
     * Gets the requiredZoneNames property: The list of required zone names for the private DNS resource name.
     * 
     * @return the requiredZoneNames value.
     */
    List<String> requiredZoneNames();

    /**
     * Gets the inner com.azure.resourcemanager.batch.fluent.models.PrivateLinkResourceInner object.
     * 
     * @return the inner object.
     */
    PrivateLinkResourceInner innerModel();
}
