// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

/**
 * The provisioned state of the resource.
 */
public enum ProvisioningState {
    /**
     * Enum value Invalid.
     */
    INVALID("Invalid"),

    /**
     * Enum value Creating.
     */
    CREATING("Creating"),

    /**
     * Enum value Deleting.
     */
    DELETING("Deleting"),

    /**
     * Enum value Succeeded.
     */
    SUCCEEDED("Succeeded"),

    /**
     * Enum value Failed.
     */
    FAILED("Failed"),

    /**
     * Enum value Cancelled.
     */
    CANCELLED("Cancelled");

    /**
     * The actual serialized value for a ProvisioningState instance.
     */
    private final String value;

    ProvisioningState(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a ProvisioningState instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed ProvisioningState object, or null if unable to parse.
     */
    public static ProvisioningState fromString(String value) {
        if (value == null) {
            return null;
        }
        ProvisioningState[] items = ProvisioningState.values();
        for (ProvisioningState item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
