// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * Details about the current or last completed resize operation.
 * 
 * Describes either the current operation (if the pool AllocationState is Resizing) or the previously completed
 * operation (if the AllocationState is Steady).
 */
@Fluent
public final class ResizeOperationStatus implements JsonSerializable<ResizeOperationStatus> {
    /*
     * The desired number of dedicated compute nodes in the pool.
     */
    private Integer targetDedicatedNodes;

    /*
     * The desired number of Spot/low-priority compute nodes in the pool.
     */
    private Integer targetLowPriorityNodes;

    /*
     * The default value is 15 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the
     * Batch service returns an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad
     * Request).
     */
    private Duration resizeTimeout;

    /*
     * The default value is requeue.
     */
    private ComputeNodeDeallocationOption nodeDeallocationOption;

    /*
     * The time when this resize operation was started.
     */
    private OffsetDateTime startTime;

    /*
     * This property is set only if an error occurred during the last pool resize, and only when the pool
     * allocationState is Steady.
     */
    private List<ResizeError> errors;

    /**
     * Creates an instance of ResizeOperationStatus class.
     */
    public ResizeOperationStatus() {
    }

    /**
     * Get the targetDedicatedNodes property: The desired number of dedicated compute nodes in the pool.
     * 
     * @return the targetDedicatedNodes value.
     */
    public Integer targetDedicatedNodes() {
        return this.targetDedicatedNodes;
    }

    /**
     * Set the targetDedicatedNodes property: The desired number of dedicated compute nodes in the pool.
     * 
     * @param targetDedicatedNodes the targetDedicatedNodes value to set.
     * @return the ResizeOperationStatus object itself.
     */
    public ResizeOperationStatus withTargetDedicatedNodes(Integer targetDedicatedNodes) {
        this.targetDedicatedNodes = targetDedicatedNodes;
        return this;
    }

    /**
     * Get the targetLowPriorityNodes property: The desired number of Spot/low-priority compute nodes in the pool.
     * 
     * @return the targetLowPriorityNodes value.
     */
    public Integer targetLowPriorityNodes() {
        return this.targetLowPriorityNodes;
    }

    /**
     * Set the targetLowPriorityNodes property: The desired number of Spot/low-priority compute nodes in the pool.
     * 
     * @param targetLowPriorityNodes the targetLowPriorityNodes value to set.
     * @return the ResizeOperationStatus object itself.
     */
    public ResizeOperationStatus withTargetLowPriorityNodes(Integer targetLowPriorityNodes) {
        this.targetLowPriorityNodes = targetLowPriorityNodes;
        return this;
    }

    /**
     * Get the resizeTimeout property: The default value is 15 minutes. The minimum value is 5 minutes. If you specify a
     * value less than 5 minutes, the Batch service returns an error; if you are calling the REST API directly, the HTTP
     * status code is 400 (Bad Request).
     * 
     * @return the resizeTimeout value.
     */
    public Duration resizeTimeout() {
        return this.resizeTimeout;
    }

    /**
     * Set the resizeTimeout property: The default value is 15 minutes. The minimum value is 5 minutes. If you specify a
     * value less than 5 minutes, the Batch service returns an error; if you are calling the REST API directly, the HTTP
     * status code is 400 (Bad Request).
     * 
     * @param resizeTimeout the resizeTimeout value to set.
     * @return the ResizeOperationStatus object itself.
     */
    public ResizeOperationStatus withResizeTimeout(Duration resizeTimeout) {
        this.resizeTimeout = resizeTimeout;
        return this;
    }

    /**
     * Get the nodeDeallocationOption property: The default value is requeue.
     * 
     * @return the nodeDeallocationOption value.
     */
    public ComputeNodeDeallocationOption nodeDeallocationOption() {
        return this.nodeDeallocationOption;
    }

    /**
     * Set the nodeDeallocationOption property: The default value is requeue.
     * 
     * @param nodeDeallocationOption the nodeDeallocationOption value to set.
     * @return the ResizeOperationStatus object itself.
     */
    public ResizeOperationStatus withNodeDeallocationOption(ComputeNodeDeallocationOption nodeDeallocationOption) {
        this.nodeDeallocationOption = nodeDeallocationOption;
        return this;
    }

    /**
     * Get the startTime property: The time when this resize operation was started.
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Set the startTime property: The time when this resize operation was started.
     * 
     * @param startTime the startTime value to set.
     * @return the ResizeOperationStatus object itself.
     */
    public ResizeOperationStatus withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the errors property: This property is set only if an error occurred during the last pool resize, and only
     * when the pool allocationState is Steady.
     * 
     * @return the errors value.
     */
    public List<ResizeError> errors() {
        return this.errors;
    }

    /**
     * Set the errors property: This property is set only if an error occurred during the last pool resize, and only
     * when the pool allocationState is Steady.
     * 
     * @param errors the errors value to set.
     * @return the ResizeOperationStatus object itself.
     */
    public ResizeOperationStatus withErrors(List<ResizeError> errors) {
        this.errors = errors;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (errors() != null) {
            errors().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("targetDedicatedNodes", this.targetDedicatedNodes);
        jsonWriter.writeNumberField("targetLowPriorityNodes", this.targetLowPriorityNodes);
        jsonWriter.writeStringField("resizeTimeout", CoreUtils.durationToStringWithDays(this.resizeTimeout));
        jsonWriter.writeStringField("nodeDeallocationOption",
            this.nodeDeallocationOption == null ? null : this.nodeDeallocationOption.toString());
        jsonWriter.writeStringField("startTime",
            this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeArrayField("errors", this.errors, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResizeOperationStatus from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResizeOperationStatus if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResizeOperationStatus.
     */
    public static ResizeOperationStatus fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResizeOperationStatus deserializedResizeOperationStatus = new ResizeOperationStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("targetDedicatedNodes".equals(fieldName)) {
                    deserializedResizeOperationStatus.targetDedicatedNodes = reader.getNullable(JsonReader::getInt);
                } else if ("targetLowPriorityNodes".equals(fieldName)) {
                    deserializedResizeOperationStatus.targetLowPriorityNodes = reader.getNullable(JsonReader::getInt);
                } else if ("resizeTimeout".equals(fieldName)) {
                    deserializedResizeOperationStatus.resizeTimeout
                        = reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                } else if ("nodeDeallocationOption".equals(fieldName)) {
                    deserializedResizeOperationStatus.nodeDeallocationOption
                        = ComputeNodeDeallocationOption.fromString(reader.getString());
                } else if ("startTime".equals(fieldName)) {
                    deserializedResizeOperationStatus.startTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("errors".equals(fieldName)) {
                    List<ResizeError> errors = reader.readArray(reader1 -> ResizeError.fromJson(reader1));
                    deserializedResizeOperationStatus.errors = errors;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResizeOperationStatus;
        });
    }
}
