// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Specifies the EncryptionType of the managed disk. It is set to VMGuestStateOnly for encryption of just the
 * VMGuestState blob, and NonPersistedTPM for not persisting firmware state in the VMGuestState blob. **Note**: It can
 * be set for only Confidential VMs and required when using Confidential VMs.
 */
public final class SecurityEncryptionTypes extends ExpandableStringEnum<SecurityEncryptionTypes> {
    /**
     * Static value NonPersistedTPM for SecurityEncryptionTypes.
     */
    public static final SecurityEncryptionTypes NON_PERSISTED_TPM = fromString("NonPersistedTPM");

    /**
     * Static value VMGuestStateOnly for SecurityEncryptionTypes.
     */
    public static final SecurityEncryptionTypes VMGUEST_STATE_ONLY = fromString("VMGuestStateOnly");

    /**
     * Creates a new instance of SecurityEncryptionTypes value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public SecurityEncryptionTypes() {
    }

    /**
     * Creates or finds a SecurityEncryptionTypes from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding SecurityEncryptionTypes.
     */
    public static SecurityEncryptionTypes fromString(String name) {
        return fromString(name, SecurityEncryptionTypes.class);
    }

    /**
     * Gets known SecurityEncryptionTypes values.
     * 
     * @return known SecurityEncryptionTypes values.
     */
    public static Collection<SecurityEncryptionTypes> values() {
        return values(SecurityEncryptionTypes.class);
    }
}
