// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

/**
 * Specifies the SecurityType of the virtual machine. It has to be set to any specified value to enable UefiSettings.
 */
public enum SecurityTypes {
    /**
     * Enum value trustedLaunch.
     */
    TRUSTED_LAUNCH("trustedLaunch"),

    /**
     * Enum value confidentialVM.
     */
    CONFIDENTIAL_VM("confidentialVM");

    /**
     * The actual serialized value for a SecurityTypes instance.
     */
    private final String value;

    SecurityTypes(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a SecurityTypes instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed SecurityTypes object, or null if unable to parse.
     */
    public static SecurityTypes fromString(String value) {
        if (value == null) {
            return null;
        }
        SecurityTypes[] items = SecurityTypes.values();
        for (SecurityTypes item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
