// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

/**
 * The storage account type for use in creating data disks or OS disk.
 */
public enum StorageAccountType {
    /**
     * Enum value Standard_LRS.
     */
    STANDARD_LRS("Standard_LRS"),

    /**
     * Enum value Premium_LRS.
     */
    PREMIUM_LRS("Premium_LRS"),

    /**
     * Enum value StandardSSD_LRS.
     */
    STANDARD_SSD_LRS("StandardSSD_LRS");

    /**
     * The actual serialized value for a StorageAccountType instance.
     */
    private final String value;

    StorageAccountType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a StorageAccountType instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed StorageAccountType object, or null if unable to parse.
     */
    public static StorageAccountType fromString(String value) {
        if (value == null) {
            return null;
        }
        StorageAccountType[] items = StorageAccountType.values();
        for (StorageAccountType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
