// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The container settings for a task.
 */
@Fluent
public final class TaskContainerSettings implements JsonSerializable<TaskContainerSettings> {
    /*
     * These additional options are supplied as arguments to the "docker create" command, in addition to those
     * controlled by the Batch Service.
     */
    private String containerRunOptions;

    /*
     * This is the full image reference, as would be specified to "docker pull". If no tag is provided as part of the
     * image name, the tag ":latest" is used as a default.
     */
    private String imageName;

    /*
     * This setting can be omitted if was already provided at pool creation.
     */
    private ContainerRegistry registry;

    /*
     * A flag to indicate where the container task working directory is. The default is 'taskWorkingDirectory'.
     */
    private ContainerWorkingDirectory workingDirectory;

    /*
     * If this array is null or be not present, container task will mount entire temporary disk drive in windows (or
     * AZ_BATCH_NODE_ROOT_DIR in Linux). It won't' mount any data paths into container if this array is set as empty.
     */
    private List<ContainerHostBatchBindMountEntry> containerHostBatchBindMounts;

    /**
     * Creates an instance of TaskContainerSettings class.
     */
    public TaskContainerSettings() {
    }

    /**
     * Get the containerRunOptions property: These additional options are supplied as arguments to the "docker create"
     * command, in addition to those controlled by the Batch Service.
     * 
     * @return the containerRunOptions value.
     */
    public String containerRunOptions() {
        return this.containerRunOptions;
    }

    /**
     * Set the containerRunOptions property: These additional options are supplied as arguments to the "docker create"
     * command, in addition to those controlled by the Batch Service.
     * 
     * @param containerRunOptions the containerRunOptions value to set.
     * @return the TaskContainerSettings object itself.
     */
    public TaskContainerSettings withContainerRunOptions(String containerRunOptions) {
        this.containerRunOptions = containerRunOptions;
        return this;
    }

    /**
     * Get the imageName property: This is the full image reference, as would be specified to "docker pull". If no tag
     * is provided as part of the image name, the tag ":latest" is used as a default.
     * 
     * @return the imageName value.
     */
    public String imageName() {
        return this.imageName;
    }

    /**
     * Set the imageName property: This is the full image reference, as would be specified to "docker pull". If no tag
     * is provided as part of the image name, the tag ":latest" is used as a default.
     * 
     * @param imageName the imageName value to set.
     * @return the TaskContainerSettings object itself.
     */
    public TaskContainerSettings withImageName(String imageName) {
        this.imageName = imageName;
        return this;
    }

    /**
     * Get the registry property: This setting can be omitted if was already provided at pool creation.
     * 
     * @return the registry value.
     */
    public ContainerRegistry registry() {
        return this.registry;
    }

    /**
     * Set the registry property: This setting can be omitted if was already provided at pool creation.
     * 
     * @param registry the registry value to set.
     * @return the TaskContainerSettings object itself.
     */
    public TaskContainerSettings withRegistry(ContainerRegistry registry) {
        this.registry = registry;
        return this;
    }

    /**
     * Get the workingDirectory property: A flag to indicate where the container task working directory is. The default
     * is 'taskWorkingDirectory'.
     * 
     * @return the workingDirectory value.
     */
    public ContainerWorkingDirectory workingDirectory() {
        return this.workingDirectory;
    }

    /**
     * Set the workingDirectory property: A flag to indicate where the container task working directory is. The default
     * is 'taskWorkingDirectory'.
     * 
     * @param workingDirectory the workingDirectory value to set.
     * @return the TaskContainerSettings object itself.
     */
    public TaskContainerSettings withWorkingDirectory(ContainerWorkingDirectory workingDirectory) {
        this.workingDirectory = workingDirectory;
        return this;
    }

    /**
     * Get the containerHostBatchBindMounts property: If this array is null or be not present, container task will mount
     * entire temporary disk drive in windows (or AZ_BATCH_NODE_ROOT_DIR in Linux). It won't' mount any data paths into
     * container if this array is set as empty.
     * 
     * @return the containerHostBatchBindMounts value.
     */
    public List<ContainerHostBatchBindMountEntry> containerHostBatchBindMounts() {
        return this.containerHostBatchBindMounts;
    }

    /**
     * Set the containerHostBatchBindMounts property: If this array is null or be not present, container task will mount
     * entire temporary disk drive in windows (or AZ_BATCH_NODE_ROOT_DIR in Linux). It won't' mount any data paths into
     * container if this array is set as empty.
     * 
     * @param containerHostBatchBindMounts the containerHostBatchBindMounts value to set.
     * @return the TaskContainerSettings object itself.
     */
    public TaskContainerSettings
        withContainerHostBatchBindMounts(List<ContainerHostBatchBindMountEntry> containerHostBatchBindMounts) {
        this.containerHostBatchBindMounts = containerHostBatchBindMounts;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (imageName() == null) {
            throw LOGGER.atError()
                .log(
                    new IllegalArgumentException("Missing required property imageName in model TaskContainerSettings"));
        }
        if (registry() != null) {
            registry().validate();
        }
        if (containerHostBatchBindMounts() != null) {
            containerHostBatchBindMounts().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(TaskContainerSettings.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("imageName", this.imageName);
        jsonWriter.writeStringField("containerRunOptions", this.containerRunOptions);
        jsonWriter.writeJsonField("registry", this.registry);
        jsonWriter.writeStringField("workingDirectory",
            this.workingDirectory == null ? null : this.workingDirectory.toString());
        jsonWriter.writeArrayField("containerHostBatchBindMounts", this.containerHostBatchBindMounts,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TaskContainerSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TaskContainerSettings if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TaskContainerSettings.
     */
    public static TaskContainerSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TaskContainerSettings deserializedTaskContainerSettings = new TaskContainerSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("imageName".equals(fieldName)) {
                    deserializedTaskContainerSettings.imageName = reader.getString();
                } else if ("containerRunOptions".equals(fieldName)) {
                    deserializedTaskContainerSettings.containerRunOptions = reader.getString();
                } else if ("registry".equals(fieldName)) {
                    deserializedTaskContainerSettings.registry = ContainerRegistry.fromJson(reader);
                } else if ("workingDirectory".equals(fieldName)) {
                    deserializedTaskContainerSettings.workingDirectory
                        = ContainerWorkingDirectory.fromString(reader.getString());
                } else if ("containerHostBatchBindMounts".equals(fieldName)) {
                    List<ContainerHostBatchBindMountEntry> containerHostBatchBindMounts
                        = reader.readArray(reader1 -> ContainerHostBatchBindMountEntry.fromJson(reader1));
                    deserializedTaskContainerSettings.containerHostBatchBindMounts = containerHostBatchBindMounts;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTaskContainerSettings;
        });
    }
}
