// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

/**
 * Specifies the mode of an upgrade to virtual machines in the scale set.&lt;br /&gt;&lt;br /&gt; Possible values
 * are:&lt;br /&gt;&lt;br /&gt; **Manual** - You control the application of updates to virtual machines in the scale
 * set. You do this by using the manualUpgrade action.&lt;br /&gt;&lt;br /&gt; **Automatic** - All virtual machines in
 * the scale set are automatically updated at the same time.&lt;br /&gt;&lt;br /&gt; **Rolling** - Scale set performs
 * updates in batches with an optional pause time in between.
 */
public enum UpgradeMode {
    /**
     * Enum value automatic.
     */
    AUTOMATIC("automatic"),

    /**
     * Enum value manual.
     */
    MANUAL("manual"),

    /**
     * Enum value rolling.
     */
    ROLLING("rolling");

    /**
     * The actual serialized value for a UpgradeMode instance.
     */
    private final String value;

    UpgradeMode(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a UpgradeMode instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed UpgradeMode object, or null if unable to parse.
     */
    public static UpgradeMode fromString(String value) {
        if (value == null) {
            return null;
        }
        UpgradeMode[] items = UpgradeMode.values();
        for (UpgradeMode item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
