// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes an upgrade policy - automatic, manual, or rolling.
 */
@Fluent
public final class UpgradePolicy implements JsonSerializable<UpgradePolicy> {
    /*
     * Specifies the mode of an upgrade to virtual machines in the scale set.<br /><br /> Possible values are:<br /><br
     * /> **Manual** - You control the application of updates to virtual machines in the scale set. You do this by using
     * the manualUpgrade action.<br /><br /> **Automatic** - All virtual machines in the scale set are automatically
     * updated at the same time.<br /><br /> **Rolling** - Scale set performs updates in batches with an optional pause
     * time in between.
     */
    private UpgradeMode mode;

    /*
     * The configuration parameters used for performing automatic OS upgrade.
     */
    private AutomaticOSUpgradePolicy automaticOSUpgradePolicy;

    /*
     * The configuration parameters used while performing a rolling upgrade.
     */
    private RollingUpgradePolicy rollingUpgradePolicy;

    /**
     * Creates an instance of UpgradePolicy class.
     */
    public UpgradePolicy() {
    }

    /**
     * Get the mode property: Specifies the mode of an upgrade to virtual machines in the scale set.&lt;br /&gt;&lt;br
     * /&gt; Possible values are:&lt;br /&gt;&lt;br /&gt; **Manual** - You control the application of updates to virtual
     * machines in the scale set. You do this by using the manualUpgrade action.&lt;br /&gt;&lt;br /&gt; **Automatic** -
     * All virtual machines in the scale set are automatically updated at the same time.&lt;br /&gt;&lt;br /&gt;
     * **Rolling** - Scale set performs updates in batches with an optional pause time in between.
     * 
     * @return the mode value.
     */
    public UpgradeMode mode() {
        return this.mode;
    }

    /**
     * Set the mode property: Specifies the mode of an upgrade to virtual machines in the scale set.&lt;br /&gt;&lt;br
     * /&gt; Possible values are:&lt;br /&gt;&lt;br /&gt; **Manual** - You control the application of updates to virtual
     * machines in the scale set. You do this by using the manualUpgrade action.&lt;br /&gt;&lt;br /&gt; **Automatic** -
     * All virtual machines in the scale set are automatically updated at the same time.&lt;br /&gt;&lt;br /&gt;
     * **Rolling** - Scale set performs updates in batches with an optional pause time in between.
     * 
     * @param mode the mode value to set.
     * @return the UpgradePolicy object itself.
     */
    public UpgradePolicy withMode(UpgradeMode mode) {
        this.mode = mode;
        return this;
    }

    /**
     * Get the automaticOSUpgradePolicy property: The configuration parameters used for performing automatic OS upgrade.
     * 
     * @return the automaticOSUpgradePolicy value.
     */
    public AutomaticOSUpgradePolicy automaticOSUpgradePolicy() {
        return this.automaticOSUpgradePolicy;
    }

    /**
     * Set the automaticOSUpgradePolicy property: The configuration parameters used for performing automatic OS upgrade.
     * 
     * @param automaticOSUpgradePolicy the automaticOSUpgradePolicy value to set.
     * @return the UpgradePolicy object itself.
     */
    public UpgradePolicy withAutomaticOSUpgradePolicy(AutomaticOSUpgradePolicy automaticOSUpgradePolicy) {
        this.automaticOSUpgradePolicy = automaticOSUpgradePolicy;
        return this;
    }

    /**
     * Get the rollingUpgradePolicy property: The configuration parameters used while performing a rolling upgrade.
     * 
     * @return the rollingUpgradePolicy value.
     */
    public RollingUpgradePolicy rollingUpgradePolicy() {
        return this.rollingUpgradePolicy;
    }

    /**
     * Set the rollingUpgradePolicy property: The configuration parameters used while performing a rolling upgrade.
     * 
     * @param rollingUpgradePolicy the rollingUpgradePolicy value to set.
     * @return the UpgradePolicy object itself.
     */
    public UpgradePolicy withRollingUpgradePolicy(RollingUpgradePolicy rollingUpgradePolicy) {
        this.rollingUpgradePolicy = rollingUpgradePolicy;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (mode() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property mode in model UpgradePolicy"));
        }
        if (automaticOSUpgradePolicy() != null) {
            automaticOSUpgradePolicy().validate();
        }
        if (rollingUpgradePolicy() != null) {
            rollingUpgradePolicy().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(UpgradePolicy.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("mode", this.mode == null ? null : this.mode.toString());
        jsonWriter.writeJsonField("automaticOSUpgradePolicy", this.automaticOSUpgradePolicy);
        jsonWriter.writeJsonField("rollingUpgradePolicy", this.rollingUpgradePolicy);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UpgradePolicy from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UpgradePolicy if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the UpgradePolicy.
     */
    public static UpgradePolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UpgradePolicy deserializedUpgradePolicy = new UpgradePolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("mode".equals(fieldName)) {
                    deserializedUpgradePolicy.mode = UpgradeMode.fromString(reader.getString());
                } else if ("automaticOSUpgradePolicy".equals(fieldName)) {
                    deserializedUpgradePolicy.automaticOSUpgradePolicy = AutomaticOSUpgradePolicy.fromJson(reader);
                } else if ("rollingUpgradePolicy".equals(fieldName)) {
                    deserializedUpgradePolicy.rollingUpgradePolicy = RollingUpgradePolicy.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUpgradePolicy;
        });
    }
}
