// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties used to create a user on an Azure Batch node.
 */
@Fluent
public final class UserAccount implements JsonSerializable<UserAccount> {
    /*
     * The name of the user account. Names can contain any Unicode characters up to a maximum length of 20.
     */
    private String name;

    /*
     * The password for the user account.
     */
    private String password;

    /*
     * nonAdmin - The auto user is a standard user without elevated access. admin - The auto user is a user with
     * elevated access and operates with full Administrator permissions. The default value is nonAdmin.
     */
    private ElevationLevel elevationLevel;

    /*
     * This property is ignored if specified on a Windows pool. If not specified, the user is created with the default
     * options.
     */
    private LinuxUserConfiguration linuxUserConfiguration;

    /*
     * This property can only be specified if the user is on a Windows pool. If not specified and on a Windows pool, the
     * user is created with the default options.
     */
    private WindowsUserConfiguration windowsUserConfiguration;

    /**
     * Creates an instance of UserAccount class.
     */
    public UserAccount() {
    }

    /**
     * Get the name property: The name of the user account. Names can contain any Unicode characters up to a maximum
     * length of 20.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the user account. Names can contain any Unicode characters up to a maximum
     * length of 20.
     * 
     * @param name the name value to set.
     * @return the UserAccount object itself.
     */
    public UserAccount withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the password property: The password for the user account.
     * 
     * @return the password value.
     */
    public String password() {
        return this.password;
    }

    /**
     * Set the password property: The password for the user account.
     * 
     * @param password the password value to set.
     * @return the UserAccount object itself.
     */
    public UserAccount withPassword(String password) {
        this.password = password;
        return this;
    }

    /**
     * Get the elevationLevel property: nonAdmin - The auto user is a standard user without elevated access. admin - The
     * auto user is a user with elevated access and operates with full Administrator permissions. The default value is
     * nonAdmin.
     * 
     * @return the elevationLevel value.
     */
    public ElevationLevel elevationLevel() {
        return this.elevationLevel;
    }

    /**
     * Set the elevationLevel property: nonAdmin - The auto user is a standard user without elevated access. admin - The
     * auto user is a user with elevated access and operates with full Administrator permissions. The default value is
     * nonAdmin.
     * 
     * @param elevationLevel the elevationLevel value to set.
     * @return the UserAccount object itself.
     */
    public UserAccount withElevationLevel(ElevationLevel elevationLevel) {
        this.elevationLevel = elevationLevel;
        return this;
    }

    /**
     * Get the linuxUserConfiguration property: This property is ignored if specified on a Windows pool. If not
     * specified, the user is created with the default options.
     * 
     * @return the linuxUserConfiguration value.
     */
    public LinuxUserConfiguration linuxUserConfiguration() {
        return this.linuxUserConfiguration;
    }

    /**
     * Set the linuxUserConfiguration property: This property is ignored if specified on a Windows pool. If not
     * specified, the user is created with the default options.
     * 
     * @param linuxUserConfiguration the linuxUserConfiguration value to set.
     * @return the UserAccount object itself.
     */
    public UserAccount withLinuxUserConfiguration(LinuxUserConfiguration linuxUserConfiguration) {
        this.linuxUserConfiguration = linuxUserConfiguration;
        return this;
    }

    /**
     * Get the windowsUserConfiguration property: This property can only be specified if the user is on a Windows pool.
     * If not specified and on a Windows pool, the user is created with the default options.
     * 
     * @return the windowsUserConfiguration value.
     */
    public WindowsUserConfiguration windowsUserConfiguration() {
        return this.windowsUserConfiguration;
    }

    /**
     * Set the windowsUserConfiguration property: This property can only be specified if the user is on a Windows pool.
     * If not specified and on a Windows pool, the user is created with the default options.
     * 
     * @param windowsUserConfiguration the windowsUserConfiguration value to set.
     * @return the UserAccount object itself.
     */
    public UserAccount withWindowsUserConfiguration(WindowsUserConfiguration windowsUserConfiguration) {
        this.windowsUserConfiguration = windowsUserConfiguration;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model UserAccount"));
        }
        if (password() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property password in model UserAccount"));
        }
        if (linuxUserConfiguration() != null) {
            linuxUserConfiguration().validate();
        }
        if (windowsUserConfiguration() != null) {
            windowsUserConfiguration().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(UserAccount.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeStringField("elevationLevel",
            this.elevationLevel == null ? null : this.elevationLevel.toString());
        jsonWriter.writeJsonField("linuxUserConfiguration", this.linuxUserConfiguration);
        jsonWriter.writeJsonField("windowsUserConfiguration", this.windowsUserConfiguration);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UserAccount from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UserAccount if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the UserAccount.
     */
    public static UserAccount fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UserAccount deserializedUserAccount = new UserAccount();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedUserAccount.name = reader.getString();
                } else if ("password".equals(fieldName)) {
                    deserializedUserAccount.password = reader.getString();
                } else if ("elevationLevel".equals(fieldName)) {
                    deserializedUserAccount.elevationLevel = ElevationLevel.fromString(reader.getString());
                } else if ("linuxUserConfiguration".equals(fieldName)) {
                    deserializedUserAccount.linuxUserConfiguration = LinuxUserConfiguration.fromJson(reader);
                } else if ("windowsUserConfiguration".equals(fieldName)) {
                    deserializedUserAccount.windowsUserConfiguration = WindowsUserConfiguration.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUserAccount;
        });
    }
}
