// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Specifies the security profile settings for the managed disk. **Note**: It can only be set for Confidential VMs and
 * is required when using Confidential VMs.
 */
@Fluent
public final class VMDiskSecurityProfile implements JsonSerializable<VMDiskSecurityProfile> {
    /*
     * Specifies the EncryptionType of the managed disk. It is set to VMGuestStateOnly for encryption of just the
     * VMGuestState blob, and NonPersistedTPM for not persisting firmware state in the VMGuestState blob. **Note**: It
     * can be set for only Confidential VMs and required when using Confidential VMs.
     */
    private SecurityEncryptionTypes securityEncryptionType;

    /**
     * Creates an instance of VMDiskSecurityProfile class.
     */
    public VMDiskSecurityProfile() {
    }

    /**
     * Get the securityEncryptionType property: Specifies the EncryptionType of the managed disk. It is set to
     * VMGuestStateOnly for encryption of just the VMGuestState blob, and NonPersistedTPM for not persisting firmware
     * state in the VMGuestState blob. **Note**: It can be set for only Confidential VMs and required when using
     * Confidential VMs.
     * 
     * @return the securityEncryptionType value.
     */
    public SecurityEncryptionTypes securityEncryptionType() {
        return this.securityEncryptionType;
    }

    /**
     * Set the securityEncryptionType property: Specifies the EncryptionType of the managed disk. It is set to
     * VMGuestStateOnly for encryption of just the VMGuestState blob, and NonPersistedTPM for not persisting firmware
     * state in the VMGuestState blob. **Note**: It can be set for only Confidential VMs and required when using
     * Confidential VMs.
     * 
     * @param securityEncryptionType the securityEncryptionType value to set.
     * @return the VMDiskSecurityProfile object itself.
     */
    public VMDiskSecurityProfile withSecurityEncryptionType(SecurityEncryptionTypes securityEncryptionType) {
        this.securityEncryptionType = securityEncryptionType;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("securityEncryptionType",
            this.securityEncryptionType == null ? null : this.securityEncryptionType.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VMDiskSecurityProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VMDiskSecurityProfile if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VMDiskSecurityProfile.
     */
    public static VMDiskSecurityProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VMDiskSecurityProfile deserializedVMDiskSecurityProfile = new VMDiskSecurityProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("securityEncryptionType".equals(fieldName)) {
                    deserializedVMDiskSecurityProfile.securityEncryptionType
                        = SecurityEncryptionTypes.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVMDiskSecurityProfile;
        });
    }
}
