// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The configuration for virtual machine extensions.
 */
@Fluent
public final class VMExtension implements JsonSerializable<VMExtension> {
    /*
     * The name of the virtual machine extension.
     */
    private String name;

    /*
     * The name of the extension handler publisher.
     */
    private String publisher;

    /*
     * The type of the extensions.
     */
    private String type;

    /*
     * The version of script handler.
     */
    private String typeHandlerVersion;

    /*
     * Indicates whether the extension should use a newer minor version if one is available at deployment time. Once
     * deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set
     * to true.
     */
    private Boolean autoUpgradeMinorVersion;

    /*
     * Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of
     * the extension available.
     */
    private Boolean enableAutomaticUpgrade;

    /*
     * JSON formatted public settings for the extension.
     */
    private Object settings;

    /*
     * The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at
     * all.
     */
    private Object protectedSettings;

    /*
     * Collection of extension names after which this extension needs to be provisioned.
     */
    private List<String> provisionAfterExtensions;

    /**
     * Creates an instance of VMExtension class.
     */
    public VMExtension() {
    }

    /**
     * Get the name property: The name of the virtual machine extension.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the virtual machine extension.
     * 
     * @param name the name value to set.
     * @return the VMExtension object itself.
     */
    public VMExtension withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the publisher property: The name of the extension handler publisher.
     * 
     * @return the publisher value.
     */
    public String publisher() {
        return this.publisher;
    }

    /**
     * Set the publisher property: The name of the extension handler publisher.
     * 
     * @param publisher the publisher value to set.
     * @return the VMExtension object itself.
     */
    public VMExtension withPublisher(String publisher) {
        this.publisher = publisher;
        return this;
    }

    /**
     * Get the type property: The type of the extensions.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: The type of the extensions.
     * 
     * @param type the type value to set.
     * @return the VMExtension object itself.
     */
    public VMExtension withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the typeHandlerVersion property: The version of script handler.
     * 
     * @return the typeHandlerVersion value.
     */
    public String typeHandlerVersion() {
        return this.typeHandlerVersion;
    }

    /**
     * Set the typeHandlerVersion property: The version of script handler.
     * 
     * @param typeHandlerVersion the typeHandlerVersion value to set.
     * @return the VMExtension object itself.
     */
    public VMExtension withTypeHandlerVersion(String typeHandlerVersion) {
        this.typeHandlerVersion = typeHandlerVersion;
        return this;
    }

    /**
     * Get the autoUpgradeMinorVersion property: Indicates whether the extension should use a newer minor version if one
     * is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless
     * redeployed, even with this property set to true.
     * 
     * @return the autoUpgradeMinorVersion value.
     */
    public Boolean autoUpgradeMinorVersion() {
        return this.autoUpgradeMinorVersion;
    }

    /**
     * Set the autoUpgradeMinorVersion property: Indicates whether the extension should use a newer minor version if one
     * is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless
     * redeployed, even with this property set to true.
     * 
     * @param autoUpgradeMinorVersion the autoUpgradeMinorVersion value to set.
     * @return the VMExtension object itself.
     */
    public VMExtension withAutoUpgradeMinorVersion(Boolean autoUpgradeMinorVersion) {
        this.autoUpgradeMinorVersion = autoUpgradeMinorVersion;
        return this;
    }

    /**
     * Get the enableAutomaticUpgrade property: Indicates whether the extension should be automatically upgraded by the
     * platform if there is a newer version of the extension available.
     * 
     * @return the enableAutomaticUpgrade value.
     */
    public Boolean enableAutomaticUpgrade() {
        return this.enableAutomaticUpgrade;
    }

    /**
     * Set the enableAutomaticUpgrade property: Indicates whether the extension should be automatically upgraded by the
     * platform if there is a newer version of the extension available.
     * 
     * @param enableAutomaticUpgrade the enableAutomaticUpgrade value to set.
     * @return the VMExtension object itself.
     */
    public VMExtension withEnableAutomaticUpgrade(Boolean enableAutomaticUpgrade) {
        this.enableAutomaticUpgrade = enableAutomaticUpgrade;
        return this;
    }

    /**
     * Get the settings property: JSON formatted public settings for the extension.
     * 
     * @return the settings value.
     */
    public Object settings() {
        return this.settings;
    }

    /**
     * Set the settings property: JSON formatted public settings for the extension.
     * 
     * @param settings the settings value to set.
     * @return the VMExtension object itself.
     */
    public VMExtension withSettings(Object settings) {
        this.settings = settings;
        return this;
    }

    /**
     * Get the protectedSettings property: The extension can contain either protectedSettings or
     * protectedSettingsFromKeyVault or no protected settings at all.
     * 
     * @return the protectedSettings value.
     */
    public Object protectedSettings() {
        return this.protectedSettings;
    }

    /**
     * Set the protectedSettings property: The extension can contain either protectedSettings or
     * protectedSettingsFromKeyVault or no protected settings at all.
     * 
     * @param protectedSettings the protectedSettings value to set.
     * @return the VMExtension object itself.
     */
    public VMExtension withProtectedSettings(Object protectedSettings) {
        this.protectedSettings = protectedSettings;
        return this;
    }

    /**
     * Get the provisionAfterExtensions property: Collection of extension names after which this extension needs to be
     * provisioned.
     * 
     * @return the provisionAfterExtensions value.
     */
    public List<String> provisionAfterExtensions() {
        return this.provisionAfterExtensions;
    }

    /**
     * Set the provisionAfterExtensions property: Collection of extension names after which this extension needs to be
     * provisioned.
     * 
     * @param provisionAfterExtensions the provisionAfterExtensions value to set.
     * @return the VMExtension object itself.
     */
    public VMExtension withProvisionAfterExtensions(List<String> provisionAfterExtensions) {
        this.provisionAfterExtensions = provisionAfterExtensions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model VMExtension"));
        }
        if (publisher() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property publisher in model VMExtension"));
        }
        if (type() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property type in model VMExtension"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(VMExtension.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("publisher", this.publisher);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("typeHandlerVersion", this.typeHandlerVersion);
        jsonWriter.writeBooleanField("autoUpgradeMinorVersion", this.autoUpgradeMinorVersion);
        jsonWriter.writeBooleanField("enableAutomaticUpgrade", this.enableAutomaticUpgrade);
        jsonWriter.writeUntypedField("settings", this.settings);
        jsonWriter.writeUntypedField("protectedSettings", this.protectedSettings);
        jsonWriter.writeArrayField("provisionAfterExtensions", this.provisionAfterExtensions,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VMExtension from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VMExtension if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VMExtension.
     */
    public static VMExtension fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VMExtension deserializedVMExtension = new VMExtension();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedVMExtension.name = reader.getString();
                } else if ("publisher".equals(fieldName)) {
                    deserializedVMExtension.publisher = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedVMExtension.type = reader.getString();
                } else if ("typeHandlerVersion".equals(fieldName)) {
                    deserializedVMExtension.typeHandlerVersion = reader.getString();
                } else if ("autoUpgradeMinorVersion".equals(fieldName)) {
                    deserializedVMExtension.autoUpgradeMinorVersion = reader.getNullable(JsonReader::getBoolean);
                } else if ("enableAutomaticUpgrade".equals(fieldName)) {
                    deserializedVMExtension.enableAutomaticUpgrade = reader.getNullable(JsonReader::getBoolean);
                } else if ("settings".equals(fieldName)) {
                    deserializedVMExtension.settings = reader.readUntyped();
                } else if ("protectedSettings".equals(fieldName)) {
                    deserializedVMExtension.protectedSettings = reader.readUntyped();
                } else if ("provisionAfterExtensions".equals(fieldName)) {
                    List<String> provisionAfterExtensions = reader.readArray(reader1 -> reader1.getString());
                    deserializedVMExtension.provisionAfterExtensions = provisionAfterExtensions;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVMExtension;
        });
    }
}
