// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The configuration for compute nodes in a pool based on the Azure Virtual Machines infrastructure.
 */
@Fluent
public final class VirtualMachineConfiguration implements JsonSerializable<VirtualMachineConfiguration> {
    /*
     * A reference to an Azure Virtual Machines Marketplace image or the Azure Image resource of a custom Virtual
     * Machine. To get the list of all imageReferences verified by Azure Batch, see the 'List supported node agent SKUs'
     * operation.
     */
    private ImageReference imageReference;

    /*
     * The Batch node agent is a program that runs on each node in the pool, and provides the command-and-control
     * interface between the node and the Batch service. There are different implementations of the node agent, known as
     * SKUs, for different operating systems. You must specify a node agent SKU which matches the selected image
     * reference. To get the list of supported node agent SKUs along with their list of verified image references, see
     * the 'List supported node agent SKUs' operation.
     */
    private String nodeAgentSkuId;

    /*
     * This property must not be specified if the imageReference specifies a Linux OS image.
     */
    private WindowsConfiguration windowsConfiguration;

    /*
     * This property must be specified if the compute nodes in the pool need to have empty data disks attached to them.
     */
    private List<DataDisk> dataDisks;

    /*
     * This only applies to images that contain the Windows operating system, and should only be used when you hold
     * valid on-premises licenses for the nodes which will be deployed. If omitted, no on-premises licensing discount is
     * applied. Values are:
     * 
     * Windows_Server - The on-premises license is for Windows Server.
     * Windows_Client - The on-premises license is for Windows Client.
     */
    private String licenseType;

    /*
     * If specified, setup is performed on each node in the pool to allow tasks to run in containers. All regular tasks
     * and job manager tasks run on this pool must specify the containerSettings property, and all other tasks may
     * specify it.
     */
    private ContainerConfiguration containerConfiguration;

    /*
     * If specified, encryption is performed on each node in the pool during node provisioning.
     */
    private DiskEncryptionConfiguration diskEncryptionConfiguration;

    /*
     * This configuration will specify rules on how nodes in the pool will be physically allocated.
     */
    private NodePlacementConfiguration nodePlacementConfiguration;

    /*
     * If specified, the extensions mentioned in this configuration will be installed on each node.
     */
    private List<VMExtension> extensions;

    /*
     * Contains configuration for ephemeral OSDisk settings.
     */
    private OSDisk osDisk;

    /*
     * Specifies the security profile settings for the virtual machine or virtual machine scale set.
     */
    private SecurityProfile securityProfile;

    /*
     * The service artifact reference id in the form of
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName
     * }/serviceArtifacts/{serviceArtifactName}/vmArtifactsProfiles/{vmArtifactsProfilesName}
     */
    private ServiceArtifactReference serviceArtifactReference;

    /**
     * Creates an instance of VirtualMachineConfiguration class.
     */
    public VirtualMachineConfiguration() {
    }

    /**
     * Get the imageReference property: A reference to an Azure Virtual Machines Marketplace image or the Azure Image
     * resource of a custom Virtual Machine. To get the list of all imageReferences verified by Azure Batch, see the
     * 'List supported node agent SKUs' operation.
     * 
     * @return the imageReference value.
     */
    public ImageReference imageReference() {
        return this.imageReference;
    }

    /**
     * Set the imageReference property: A reference to an Azure Virtual Machines Marketplace image or the Azure Image
     * resource of a custom Virtual Machine. To get the list of all imageReferences verified by Azure Batch, see the
     * 'List supported node agent SKUs' operation.
     * 
     * @param imageReference the imageReference value to set.
     * @return the VirtualMachineConfiguration object itself.
     */
    public VirtualMachineConfiguration withImageReference(ImageReference imageReference) {
        this.imageReference = imageReference;
        return this;
    }

    /**
     * Get the nodeAgentSkuId property: The Batch node agent is a program that runs on each node in the pool, and
     * provides the command-and-control interface between the node and the Batch service. There are different
     * implementations of the node agent, known as SKUs, for different operating systems. You must specify a node agent
     * SKU which matches the selected image reference. To get the list of supported node agent SKUs along with their
     * list of verified image references, see the 'List supported node agent SKUs' operation.
     * 
     * @return the nodeAgentSkuId value.
     */
    public String nodeAgentSkuId() {
        return this.nodeAgentSkuId;
    }

    /**
     * Set the nodeAgentSkuId property: The Batch node agent is a program that runs on each node in the pool, and
     * provides the command-and-control interface between the node and the Batch service. There are different
     * implementations of the node agent, known as SKUs, for different operating systems. You must specify a node agent
     * SKU which matches the selected image reference. To get the list of supported node agent SKUs along with their
     * list of verified image references, see the 'List supported node agent SKUs' operation.
     * 
     * @param nodeAgentSkuId the nodeAgentSkuId value to set.
     * @return the VirtualMachineConfiguration object itself.
     */
    public VirtualMachineConfiguration withNodeAgentSkuId(String nodeAgentSkuId) {
        this.nodeAgentSkuId = nodeAgentSkuId;
        return this;
    }

    /**
     * Get the windowsConfiguration property: This property must not be specified if the imageReference specifies a
     * Linux OS image.
     * 
     * @return the windowsConfiguration value.
     */
    public WindowsConfiguration windowsConfiguration() {
        return this.windowsConfiguration;
    }

    /**
     * Set the windowsConfiguration property: This property must not be specified if the imageReference specifies a
     * Linux OS image.
     * 
     * @param windowsConfiguration the windowsConfiguration value to set.
     * @return the VirtualMachineConfiguration object itself.
     */
    public VirtualMachineConfiguration withWindowsConfiguration(WindowsConfiguration windowsConfiguration) {
        this.windowsConfiguration = windowsConfiguration;
        return this;
    }

    /**
     * Get the dataDisks property: This property must be specified if the compute nodes in the pool need to have empty
     * data disks attached to them.
     * 
     * @return the dataDisks value.
     */
    public List<DataDisk> dataDisks() {
        return this.dataDisks;
    }

    /**
     * Set the dataDisks property: This property must be specified if the compute nodes in the pool need to have empty
     * data disks attached to them.
     * 
     * @param dataDisks the dataDisks value to set.
     * @return the VirtualMachineConfiguration object itself.
     */
    public VirtualMachineConfiguration withDataDisks(List<DataDisk> dataDisks) {
        this.dataDisks = dataDisks;
        return this;
    }

    /**
     * Get the licenseType property: This only applies to images that contain the Windows operating system, and should
     * only be used when you hold valid on-premises licenses for the nodes which will be deployed. If omitted, no
     * on-premises licensing discount is applied. Values are:
     * 
     * Windows_Server - The on-premises license is for Windows Server.
     * Windows_Client - The on-premises license is for Windows Client.
     * 
     * @return the licenseType value.
     */
    public String licenseType() {
        return this.licenseType;
    }

    /**
     * Set the licenseType property: This only applies to images that contain the Windows operating system, and should
     * only be used when you hold valid on-premises licenses for the nodes which will be deployed. If omitted, no
     * on-premises licensing discount is applied. Values are:
     * 
     * Windows_Server - The on-premises license is for Windows Server.
     * Windows_Client - The on-premises license is for Windows Client.
     * 
     * @param licenseType the licenseType value to set.
     * @return the VirtualMachineConfiguration object itself.
     */
    public VirtualMachineConfiguration withLicenseType(String licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    /**
     * Get the containerConfiguration property: If specified, setup is performed on each node in the pool to allow tasks
     * to run in containers. All regular tasks and job manager tasks run on this pool must specify the containerSettings
     * property, and all other tasks may specify it.
     * 
     * @return the containerConfiguration value.
     */
    public ContainerConfiguration containerConfiguration() {
        return this.containerConfiguration;
    }

    /**
     * Set the containerConfiguration property: If specified, setup is performed on each node in the pool to allow tasks
     * to run in containers. All regular tasks and job manager tasks run on this pool must specify the containerSettings
     * property, and all other tasks may specify it.
     * 
     * @param containerConfiguration the containerConfiguration value to set.
     * @return the VirtualMachineConfiguration object itself.
     */
    public VirtualMachineConfiguration withContainerConfiguration(ContainerConfiguration containerConfiguration) {
        this.containerConfiguration = containerConfiguration;
        return this;
    }

    /**
     * Get the diskEncryptionConfiguration property: If specified, encryption is performed on each node in the pool
     * during node provisioning.
     * 
     * @return the diskEncryptionConfiguration value.
     */
    public DiskEncryptionConfiguration diskEncryptionConfiguration() {
        return this.diskEncryptionConfiguration;
    }

    /**
     * Set the diskEncryptionConfiguration property: If specified, encryption is performed on each node in the pool
     * during node provisioning.
     * 
     * @param diskEncryptionConfiguration the diskEncryptionConfiguration value to set.
     * @return the VirtualMachineConfiguration object itself.
     */
    public VirtualMachineConfiguration
        withDiskEncryptionConfiguration(DiskEncryptionConfiguration diskEncryptionConfiguration) {
        this.diskEncryptionConfiguration = diskEncryptionConfiguration;
        return this;
    }

    /**
     * Get the nodePlacementConfiguration property: This configuration will specify rules on how nodes in the pool will
     * be physically allocated.
     * 
     * @return the nodePlacementConfiguration value.
     */
    public NodePlacementConfiguration nodePlacementConfiguration() {
        return this.nodePlacementConfiguration;
    }

    /**
     * Set the nodePlacementConfiguration property: This configuration will specify rules on how nodes in the pool will
     * be physically allocated.
     * 
     * @param nodePlacementConfiguration the nodePlacementConfiguration value to set.
     * @return the VirtualMachineConfiguration object itself.
     */
    public VirtualMachineConfiguration
        withNodePlacementConfiguration(NodePlacementConfiguration nodePlacementConfiguration) {
        this.nodePlacementConfiguration = nodePlacementConfiguration;
        return this;
    }

    /**
     * Get the extensions property: If specified, the extensions mentioned in this configuration will be installed on
     * each node.
     * 
     * @return the extensions value.
     */
    public List<VMExtension> extensions() {
        return this.extensions;
    }

    /**
     * Set the extensions property: If specified, the extensions mentioned in this configuration will be installed on
     * each node.
     * 
     * @param extensions the extensions value to set.
     * @return the VirtualMachineConfiguration object itself.
     */
    public VirtualMachineConfiguration withExtensions(List<VMExtension> extensions) {
        this.extensions = extensions;
        return this;
    }

    /**
     * Get the osDisk property: Contains configuration for ephemeral OSDisk settings.
     * 
     * @return the osDisk value.
     */
    public OSDisk osDisk() {
        return this.osDisk;
    }

    /**
     * Set the osDisk property: Contains configuration for ephemeral OSDisk settings.
     * 
     * @param osDisk the osDisk value to set.
     * @return the VirtualMachineConfiguration object itself.
     */
    public VirtualMachineConfiguration withOsDisk(OSDisk osDisk) {
        this.osDisk = osDisk;
        return this;
    }

    /**
     * Get the securityProfile property: Specifies the security profile settings for the virtual machine or virtual
     * machine scale set.
     * 
     * @return the securityProfile value.
     */
    public SecurityProfile securityProfile() {
        return this.securityProfile;
    }

    /**
     * Set the securityProfile property: Specifies the security profile settings for the virtual machine or virtual
     * machine scale set.
     * 
     * @param securityProfile the securityProfile value to set.
     * @return the VirtualMachineConfiguration object itself.
     */
    public VirtualMachineConfiguration withSecurityProfile(SecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    /**
     * Get the serviceArtifactReference property: The service artifact reference id in the form of
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/serviceArtifacts/{serviceArtifactName}/vmArtifactsProfiles/{vmArtifactsProfilesName}.
     * 
     * @return the serviceArtifactReference value.
     */
    public ServiceArtifactReference serviceArtifactReference() {
        return this.serviceArtifactReference;
    }

    /**
     * Set the serviceArtifactReference property: The service artifact reference id in the form of
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/serviceArtifacts/{serviceArtifactName}/vmArtifactsProfiles/{vmArtifactsProfilesName}.
     * 
     * @param serviceArtifactReference the serviceArtifactReference value to set.
     * @return the VirtualMachineConfiguration object itself.
     */
    public VirtualMachineConfiguration withServiceArtifactReference(ServiceArtifactReference serviceArtifactReference) {
        this.serviceArtifactReference = serviceArtifactReference;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (imageReference() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property imageReference in model VirtualMachineConfiguration"));
        } else {
            imageReference().validate();
        }
        if (nodeAgentSkuId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property nodeAgentSkuId in model VirtualMachineConfiguration"));
        }
        if (windowsConfiguration() != null) {
            windowsConfiguration().validate();
        }
        if (dataDisks() != null) {
            dataDisks().forEach(e -> e.validate());
        }
        if (containerConfiguration() != null) {
            containerConfiguration().validate();
        }
        if (diskEncryptionConfiguration() != null) {
            diskEncryptionConfiguration().validate();
        }
        if (nodePlacementConfiguration() != null) {
            nodePlacementConfiguration().validate();
        }
        if (extensions() != null) {
            extensions().forEach(e -> e.validate());
        }
        if (osDisk() != null) {
            osDisk().validate();
        }
        if (securityProfile() != null) {
            securityProfile().validate();
        }
        if (serviceArtifactReference() != null) {
            serviceArtifactReference().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(VirtualMachineConfiguration.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("imageReference", this.imageReference);
        jsonWriter.writeStringField("nodeAgentSkuId", this.nodeAgentSkuId);
        jsonWriter.writeJsonField("windowsConfiguration", this.windowsConfiguration);
        jsonWriter.writeArrayField("dataDisks", this.dataDisks, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("licenseType", this.licenseType);
        jsonWriter.writeJsonField("containerConfiguration", this.containerConfiguration);
        jsonWriter.writeJsonField("diskEncryptionConfiguration", this.diskEncryptionConfiguration);
        jsonWriter.writeJsonField("nodePlacementConfiguration", this.nodePlacementConfiguration);
        jsonWriter.writeArrayField("extensions", this.extensions, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("osDisk", this.osDisk);
        jsonWriter.writeJsonField("securityProfile", this.securityProfile);
        jsonWriter.writeJsonField("serviceArtifactReference", this.serviceArtifactReference);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualMachineConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualMachineConfiguration if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VirtualMachineConfiguration.
     */
    public static VirtualMachineConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachineConfiguration deserializedVirtualMachineConfiguration = new VirtualMachineConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("imageReference".equals(fieldName)) {
                    deserializedVirtualMachineConfiguration.imageReference = ImageReference.fromJson(reader);
                } else if ("nodeAgentSkuId".equals(fieldName)) {
                    deserializedVirtualMachineConfiguration.nodeAgentSkuId = reader.getString();
                } else if ("windowsConfiguration".equals(fieldName)) {
                    deserializedVirtualMachineConfiguration.windowsConfiguration
                        = WindowsConfiguration.fromJson(reader);
                } else if ("dataDisks".equals(fieldName)) {
                    List<DataDisk> dataDisks = reader.readArray(reader1 -> DataDisk.fromJson(reader1));
                    deserializedVirtualMachineConfiguration.dataDisks = dataDisks;
                } else if ("licenseType".equals(fieldName)) {
                    deserializedVirtualMachineConfiguration.licenseType = reader.getString();
                } else if ("containerConfiguration".equals(fieldName)) {
                    deserializedVirtualMachineConfiguration.containerConfiguration
                        = ContainerConfiguration.fromJson(reader);
                } else if ("diskEncryptionConfiguration".equals(fieldName)) {
                    deserializedVirtualMachineConfiguration.diskEncryptionConfiguration
                        = DiskEncryptionConfiguration.fromJson(reader);
                } else if ("nodePlacementConfiguration".equals(fieldName)) {
                    deserializedVirtualMachineConfiguration.nodePlacementConfiguration
                        = NodePlacementConfiguration.fromJson(reader);
                } else if ("extensions".equals(fieldName)) {
                    List<VMExtension> extensions = reader.readArray(reader1 -> VMExtension.fromJson(reader1));
                    deserializedVirtualMachineConfiguration.extensions = extensions;
                } else if ("osDisk".equals(fieldName)) {
                    deserializedVirtualMachineConfiguration.osDisk = OSDisk.fromJson(reader);
                } else if ("securityProfile".equals(fieldName)) {
                    deserializedVirtualMachineConfiguration.securityProfile = SecurityProfile.fromJson(reader);
                } else if ("serviceArtifactReference".equals(fieldName)) {
                    deserializedVirtualMachineConfiguration.serviceArtifactReference
                        = ServiceArtifactReference.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualMachineConfiguration;
        });
    }
}
