// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A VM Family and its associated core quota for the Batch account.
 */
@Immutable
public final class VirtualMachineFamilyCoreQuota implements JsonSerializable<VirtualMachineFamilyCoreQuota> {
    /*
     * The Virtual Machine family name.
     */
    private String name;

    /*
     * The core quota for the VM family for the Batch account.
     */
    private Integer coreQuota;

    /**
     * Creates an instance of VirtualMachineFamilyCoreQuota class.
     */
    public VirtualMachineFamilyCoreQuota() {
    }

    /**
     * Get the name property: The Virtual Machine family name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the coreQuota property: The core quota for the VM family for the Batch account.
     * 
     * @return the coreQuota value.
     */
    public Integer coreQuota() {
        return this.coreQuota;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualMachineFamilyCoreQuota from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualMachineFamilyCoreQuota if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualMachineFamilyCoreQuota.
     */
    public static VirtualMachineFamilyCoreQuota fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachineFamilyCoreQuota deserializedVirtualMachineFamilyCoreQuota
                = new VirtualMachineFamilyCoreQuota();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedVirtualMachineFamilyCoreQuota.name = reader.getString();
                } else if ("coreQuota".equals(fieldName)) {
                    deserializedVirtualMachineFamilyCoreQuota.coreQuota = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualMachineFamilyCoreQuota;
        });
    }
}
