// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties used to create a user account on a Windows node.
 */
@Fluent
public final class WindowsUserConfiguration implements JsonSerializable<WindowsUserConfiguration> {
    /*
     * Specifies login mode for the user. The default value is Interactive.
     */
    private LoginMode loginMode;

    /**
     * Creates an instance of WindowsUserConfiguration class.
     */
    public WindowsUserConfiguration() {
    }

    /**
     * Get the loginMode property: Specifies login mode for the user. The default value is Interactive.
     * 
     * @return the loginMode value.
     */
    public LoginMode loginMode() {
        return this.loginMode;
    }

    /**
     * Set the loginMode property: Specifies login mode for the user. The default value is Interactive.
     * 
     * @param loginMode the loginMode value to set.
     * @return the WindowsUserConfiguration object itself.
     */
    public WindowsUserConfiguration withLoginMode(LoginMode loginMode) {
        this.loginMode = loginMode;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("loginMode", this.loginMode == null ? null : this.loginMode.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WindowsUserConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WindowsUserConfiguration if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the WindowsUserConfiguration.
     */
    public static WindowsUserConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WindowsUserConfiguration deserializedWindowsUserConfiguration = new WindowsUserConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("loginMode".equals(fieldName)) {
                    deserializedWindowsUserConfiguration.loginMode = LoginMode.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWindowsUserConfiguration;
        });
    }
}
