/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.fluent.models.ApplicationProperties;
import com.azure.resourcemanager.batch.models.AzureProxyResource;
import java.io.IOException;
import java.util.Map;

public final class ApplicationInner
extends AzureProxyResource {
    private ApplicationProperties innerProperties;
    private String etag;
    private String type;
    private String name;
    private String id;

    private ApplicationProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String etag() {
        return this.etag;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public ApplicationInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    public ApplicationInner withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    public Boolean allowUpdates() {
        return this.innerProperties() == null ? null : this.innerProperties().allowUpdates();
    }

    public ApplicationInner withAllowUpdates(Boolean allowUpdates) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationProperties();
        }
        this.innerProperties().withAllowUpdates(allowUpdates);
        return this;
    }

    public String defaultVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultVersion();
    }

    public ApplicationInner withDefaultVersion(String defaultVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationProperties();
        }
        this.innerProperties().withDefaultVersion(defaultVersion);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ApplicationInner fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationInner)((Object)jsonReader.readObject(reader -> {
            ApplicationInner deserializedApplicationInner = new ApplicationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedApplicationInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedApplicationInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedApplicationInner.type = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedApplicationInner.etag = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedApplicationInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedApplicationInner.innerProperties = ApplicationProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationInner;
        }));
    }
}

