/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.fluent.models.ApplicationPackageProperties;
import com.azure.resourcemanager.batch.models.AzureProxyResource;
import com.azure.resourcemanager.batch.models.PackageState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class ApplicationPackageInner
extends AzureProxyResource {
    private ApplicationPackageProperties innerProperties;
    private String etag;
    private String type;
    private String name;
    private String id;

    private ApplicationPackageProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String etag() {
        return this.etag;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public ApplicationPackageInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public PackageState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    public String format() {
        return this.innerProperties() == null ? null : this.innerProperties().format();
    }

    public String storageUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().storageUrl();
    }

    public OffsetDateTime storageUrlExpiry() {
        return this.innerProperties() == null ? null : this.innerProperties().storageUrlExpiry();
    }

    public OffsetDateTime lastActivationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastActivationTime();
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ApplicationPackageInner fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationPackageInner)((Object)jsonReader.readObject(reader -> {
            ApplicationPackageInner deserializedApplicationPackageInner = new ApplicationPackageInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedApplicationPackageInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedApplicationPackageInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedApplicationPackageInner.type = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedApplicationPackageInner.etag = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedApplicationPackageInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedApplicationPackageInner.innerProperties = ApplicationPackageProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationPackageInner;
        }));
    }
}

