/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.PackageState;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class ApplicationPackageProperties
implements JsonSerializable<ApplicationPackageProperties> {
    private PackageState state;
    private String format;
    private String storageUrl;
    private OffsetDateTime storageUrlExpiry;
    private OffsetDateTime lastActivationTime;

    public PackageState state() {
        return this.state;
    }

    public String format() {
        return this.format;
    }

    public String storageUrl() {
        return this.storageUrl;
    }

    public OffsetDateTime storageUrlExpiry() {
        return this.storageUrlExpiry;
    }

    public OffsetDateTime lastActivationTime() {
        return this.lastActivationTime;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ApplicationPackageProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationPackageProperties)jsonReader.readObject(reader -> {
            ApplicationPackageProperties deserializedApplicationPackageProperties = new ApplicationPackageProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    deserializedApplicationPackageProperties.state = PackageState.fromString(reader.getString());
                    continue;
                }
                if ("format".equals(fieldName)) {
                    deserializedApplicationPackageProperties.format = reader.getString();
                    continue;
                }
                if ("storageUrl".equals(fieldName)) {
                    deserializedApplicationPackageProperties.storageUrl = reader.getString();
                    continue;
                }
                if ("storageUrlExpiry".equals(fieldName)) {
                    deserializedApplicationPackageProperties.storageUrlExpiry = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastActivationTime".equals(fieldName)) {
                    deserializedApplicationPackageProperties.lastActivationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationPackageProperties;
        });
    }
}

