/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ApplicationProperties
implements JsonSerializable<ApplicationProperties> {
    private String displayName;
    private Boolean allowUpdates;
    private String defaultVersion;

    public String displayName() {
        return this.displayName;
    }

    public ApplicationProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public Boolean allowUpdates() {
        return this.allowUpdates;
    }

    public ApplicationProperties withAllowUpdates(Boolean allowUpdates) {
        this.allowUpdates = allowUpdates;
        return this;
    }

    public String defaultVersion() {
        return this.defaultVersion;
    }

    public ApplicationProperties withDefaultVersion(String defaultVersion) {
        this.defaultVersion = defaultVersion;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeBooleanField("allowUpdates", this.allowUpdates);
        jsonWriter.writeStringField("defaultVersion", this.defaultVersion);
        return jsonWriter.writeEndObject();
    }

    public static ApplicationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationProperties)jsonReader.readObject(reader -> {
            ApplicationProperties deserializedApplicationProperties = new ApplicationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("displayName".equals(fieldName)) {
                    deserializedApplicationProperties.displayName = reader.getString();
                    continue;
                }
                if ("allowUpdates".equals(fieldName)) {
                    deserializedApplicationProperties.allowUpdates = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("defaultVersion".equals(fieldName)) {
                    deserializedApplicationProperties.defaultVersion = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationProperties;
        });
    }
}

