/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.AuthenticationMode;
import com.azure.resourcemanager.batch.models.AutoStorageBaseProperties;
import com.azure.resourcemanager.batch.models.EncryptionProperties;
import com.azure.resourcemanager.batch.models.KeyVaultReference;
import com.azure.resourcemanager.batch.models.NetworkProfile;
import com.azure.resourcemanager.batch.models.PoolAllocationMode;
import com.azure.resourcemanager.batch.models.PublicNetworkAccessType;
import java.io.IOException;
import java.util.List;

public final class BatchAccountCreateProperties
implements JsonSerializable<BatchAccountCreateProperties> {
    private AutoStorageBaseProperties autoStorage;
    private PoolAllocationMode poolAllocationMode;
    private KeyVaultReference keyVaultReference;
    private PublicNetworkAccessType publicNetworkAccess;
    private NetworkProfile networkProfile;
    private EncryptionProperties encryption;
    private List<AuthenticationMode> allowedAuthenticationModes;

    public AutoStorageBaseProperties autoStorage() {
        return this.autoStorage;
    }

    public BatchAccountCreateProperties withAutoStorage(AutoStorageBaseProperties autoStorage) {
        this.autoStorage = autoStorage;
        return this;
    }

    public PoolAllocationMode poolAllocationMode() {
        return this.poolAllocationMode;
    }

    public BatchAccountCreateProperties withPoolAllocationMode(PoolAllocationMode poolAllocationMode) {
        this.poolAllocationMode = poolAllocationMode;
        return this;
    }

    public KeyVaultReference keyVaultReference() {
        return this.keyVaultReference;
    }

    public BatchAccountCreateProperties withKeyVaultReference(KeyVaultReference keyVaultReference) {
        this.keyVaultReference = keyVaultReference;
        return this;
    }

    public PublicNetworkAccessType publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public BatchAccountCreateProperties withPublicNetworkAccess(PublicNetworkAccessType publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public NetworkProfile networkProfile() {
        return this.networkProfile;
    }

    public BatchAccountCreateProperties withNetworkProfile(NetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    public EncryptionProperties encryption() {
        return this.encryption;
    }

    public BatchAccountCreateProperties withEncryption(EncryptionProperties encryption) {
        this.encryption = encryption;
        return this;
    }

    public List<AuthenticationMode> allowedAuthenticationModes() {
        return this.allowedAuthenticationModes;
    }

    public BatchAccountCreateProperties withAllowedAuthenticationModes(List<AuthenticationMode> allowedAuthenticationModes) {
        this.allowedAuthenticationModes = allowedAuthenticationModes;
        return this;
    }

    public void validate() {
        if (this.autoStorage() != null) {
            this.autoStorage().validate();
        }
        if (this.keyVaultReference() != null) {
            this.keyVaultReference().validate();
        }
        if (this.networkProfile() != null) {
            this.networkProfile().validate();
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("autoStorage", (JsonSerializable)this.autoStorage);
        jsonWriter.writeStringField("poolAllocationMode", this.poolAllocationMode == null ? null : this.poolAllocationMode.toString());
        jsonWriter.writeJsonField("keyVaultReference", (JsonSerializable)this.keyVaultReference);
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeJsonField("networkProfile", (JsonSerializable)this.networkProfile);
        jsonWriter.writeJsonField("encryption", (JsonSerializable)this.encryption);
        jsonWriter.writeArrayField("allowedAuthenticationModes", this.allowedAuthenticationModes, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static BatchAccountCreateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (BatchAccountCreateProperties)jsonReader.readObject(reader -> {
            BatchAccountCreateProperties deserializedBatchAccountCreateProperties = new BatchAccountCreateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("autoStorage".equals(fieldName)) {
                    deserializedBatchAccountCreateProperties.autoStorage = AutoStorageBaseProperties.fromJson(reader);
                    continue;
                }
                if ("poolAllocationMode".equals(fieldName)) {
                    deserializedBatchAccountCreateProperties.poolAllocationMode = PoolAllocationMode.fromString(reader.getString());
                    continue;
                }
                if ("keyVaultReference".equals(fieldName)) {
                    deserializedBatchAccountCreateProperties.keyVaultReference = KeyVaultReference.fromJson(reader);
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedBatchAccountCreateProperties.publicNetworkAccess = PublicNetworkAccessType.fromString(reader.getString());
                    continue;
                }
                if ("networkProfile".equals(fieldName)) {
                    deserializedBatchAccountCreateProperties.networkProfile = NetworkProfile.fromJson(reader);
                    continue;
                }
                if ("encryption".equals(fieldName)) {
                    deserializedBatchAccountCreateProperties.encryption = EncryptionProperties.fromJson(reader);
                    continue;
                }
                if ("allowedAuthenticationModes".equals(fieldName)) {
                    List allowedAuthenticationModes;
                    deserializedBatchAccountCreateProperties.allowedAuthenticationModes = allowedAuthenticationModes = reader.readArray(reader1 -> AuthenticationMode.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBatchAccountCreateProperties;
        });
    }
}

