/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.fluent.models.BatchAccountProperties;
import com.azure.resourcemanager.batch.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.batch.models.AuthenticationMode;
import com.azure.resourcemanager.batch.models.AutoStorageProperties;
import com.azure.resourcemanager.batch.models.BatchAccountIdentity;
import com.azure.resourcemanager.batch.models.EncryptionProperties;
import com.azure.resourcemanager.batch.models.KeyVaultReference;
import com.azure.resourcemanager.batch.models.NetworkProfile;
import com.azure.resourcemanager.batch.models.PoolAllocationMode;
import com.azure.resourcemanager.batch.models.ProvisioningState;
import com.azure.resourcemanager.batch.models.PublicNetworkAccessType;
import com.azure.resourcemanager.batch.models.VirtualMachineFamilyCoreQuota;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class BatchAccountInner
extends Resource {
    private BatchAccountProperties innerProperties;
    private BatchAccountIdentity identity;
    private String type;
    private String name;
    private String id;

    private BatchAccountProperties innerProperties() {
        return this.innerProperties;
    }

    public BatchAccountIdentity identity() {
        return this.identity;
    }

    public BatchAccountInner withIdentity(BatchAccountIdentity identity) {
        this.identity = identity;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public BatchAccountInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public BatchAccountInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String accountEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().accountEndpoint();
    }

    public String nodeManagementEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().nodeManagementEndpoint();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public PoolAllocationMode poolAllocationMode() {
        return this.innerProperties() == null ? null : this.innerProperties().poolAllocationMode();
    }

    public KeyVaultReference keyVaultReference() {
        return this.innerProperties() == null ? null : this.innerProperties().keyVaultReference();
    }

    public PublicNetworkAccessType publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public BatchAccountInner withPublicNetworkAccess(PublicNetworkAccessType publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BatchAccountProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public NetworkProfile networkProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().networkProfile();
    }

    public BatchAccountInner withNetworkProfile(NetworkProfile networkProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BatchAccountProperties();
        }
        this.innerProperties().withNetworkProfile(networkProfile);
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    public AutoStorageProperties autoStorage() {
        return this.innerProperties() == null ? null : this.innerProperties().autoStorage();
    }

    public EncryptionProperties encryption() {
        return this.innerProperties() == null ? null : this.innerProperties().encryption();
    }

    public Integer dedicatedCoreQuota() {
        return this.innerProperties() == null ? null : this.innerProperties().dedicatedCoreQuota();
    }

    public Integer lowPriorityCoreQuota() {
        return this.innerProperties() == null ? null : this.innerProperties().lowPriorityCoreQuota();
    }

    public List<VirtualMachineFamilyCoreQuota> dedicatedCoreQuotaPerVMFamily() {
        return this.innerProperties() == null ? null : this.innerProperties().dedicatedCoreQuotaPerVMFamily();
    }

    public Boolean dedicatedCoreQuotaPerVMFamilyEnforced() {
        return this.innerProperties() == null ? null : this.innerProperties().dedicatedCoreQuotaPerVMFamilyEnforced();
    }

    public Integer poolQuota() {
        return this.innerProperties() == null ? null : this.innerProperties().poolQuota();
    }

    public Integer activeJobAndJobScheduleQuota() {
        return this.innerProperties() == null ? null : this.innerProperties().activeJobAndJobScheduleQuota();
    }

    public List<AuthenticationMode> allowedAuthenticationModes() {
        return this.innerProperties() == null ? null : this.innerProperties().allowedAuthenticationModes();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static BatchAccountInner fromJson(JsonReader jsonReader) throws IOException {
        return (BatchAccountInner)((Object)jsonReader.readObject(reader -> {
            BatchAccountInner deserializedBatchAccountInner = new BatchAccountInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedBatchAccountInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedBatchAccountInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedBatchAccountInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedBatchAccountInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedBatchAccountInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedBatchAccountInner.innerProperties = BatchAccountProperties.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedBatchAccountInner.identity = BatchAccountIdentity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBatchAccountInner;
        }));
    }
}

