/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.batch.models.AuthenticationMode;
import com.azure.resourcemanager.batch.models.AutoStorageProperties;
import com.azure.resourcemanager.batch.models.EncryptionProperties;
import com.azure.resourcemanager.batch.models.KeyVaultReference;
import com.azure.resourcemanager.batch.models.NetworkProfile;
import com.azure.resourcemanager.batch.models.PoolAllocationMode;
import com.azure.resourcemanager.batch.models.ProvisioningState;
import com.azure.resourcemanager.batch.models.PublicNetworkAccessType;
import com.azure.resourcemanager.batch.models.VirtualMachineFamilyCoreQuota;
import java.io.IOException;
import java.util.List;

public final class BatchAccountProperties
implements JsonSerializable<BatchAccountProperties> {
    private String accountEndpoint;
    private String nodeManagementEndpoint;
    private ProvisioningState provisioningState;
    private PoolAllocationMode poolAllocationMode;
    private KeyVaultReference keyVaultReference;
    private PublicNetworkAccessType publicNetworkAccess;
    private NetworkProfile networkProfile;
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    private AutoStorageProperties autoStorage;
    private EncryptionProperties encryption;
    private Integer dedicatedCoreQuota;
    private Integer lowPriorityCoreQuota;
    private List<VirtualMachineFamilyCoreQuota> dedicatedCoreQuotaPerVMFamily;
    private Boolean dedicatedCoreQuotaPerVMFamilyEnforced;
    private Integer poolQuota;
    private Integer activeJobAndJobScheduleQuota;
    private List<AuthenticationMode> allowedAuthenticationModes;

    public String accountEndpoint() {
        return this.accountEndpoint;
    }

    public String nodeManagementEndpoint() {
        return this.nodeManagementEndpoint;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public PoolAllocationMode poolAllocationMode() {
        return this.poolAllocationMode;
    }

    public KeyVaultReference keyVaultReference() {
        return this.keyVaultReference;
    }

    public PublicNetworkAccessType publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public BatchAccountProperties withPublicNetworkAccess(PublicNetworkAccessType publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public NetworkProfile networkProfile() {
        return this.networkProfile;
    }

    public BatchAccountProperties withNetworkProfile(NetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public AutoStorageProperties autoStorage() {
        return this.autoStorage;
    }

    public EncryptionProperties encryption() {
        return this.encryption;
    }

    public Integer dedicatedCoreQuota() {
        return this.dedicatedCoreQuota;
    }

    public Integer lowPriorityCoreQuota() {
        return this.lowPriorityCoreQuota;
    }

    public List<VirtualMachineFamilyCoreQuota> dedicatedCoreQuotaPerVMFamily() {
        return this.dedicatedCoreQuotaPerVMFamily;
    }

    public Boolean dedicatedCoreQuotaPerVMFamilyEnforced() {
        return this.dedicatedCoreQuotaPerVMFamilyEnforced;
    }

    public Integer poolQuota() {
        return this.poolQuota;
    }

    public Integer activeJobAndJobScheduleQuota() {
        return this.activeJobAndJobScheduleQuota;
    }

    public List<AuthenticationMode> allowedAuthenticationModes() {
        return this.allowedAuthenticationModes;
    }

    public void validate() {
        if (this.keyVaultReference() != null) {
            this.keyVaultReference().validate();
        }
        if (this.networkProfile() != null) {
            this.networkProfile().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.autoStorage() != null) {
            this.autoStorage().validate();
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.dedicatedCoreQuotaPerVMFamily() != null) {
            this.dedicatedCoreQuotaPerVMFamily().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeJsonField("networkProfile", (JsonSerializable)this.networkProfile);
        return jsonWriter.writeEndObject();
    }

    public static BatchAccountProperties fromJson(JsonReader jsonReader) throws IOException {
        return (BatchAccountProperties)jsonReader.readObject(reader -> {
            BatchAccountProperties deserializedBatchAccountProperties = new BatchAccountProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("accountEndpoint".equals(fieldName)) {
                    deserializedBatchAccountProperties.accountEndpoint = reader.getString();
                    continue;
                }
                if ("nodeManagementEndpoint".equals(fieldName)) {
                    deserializedBatchAccountProperties.nodeManagementEndpoint = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedBatchAccountProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("poolAllocationMode".equals(fieldName)) {
                    deserializedBatchAccountProperties.poolAllocationMode = PoolAllocationMode.fromString(reader.getString());
                    continue;
                }
                if ("keyVaultReference".equals(fieldName)) {
                    deserializedBatchAccountProperties.keyVaultReference = KeyVaultReference.fromJson(reader);
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedBatchAccountProperties.publicNetworkAccess = PublicNetworkAccessType.fromString(reader.getString());
                    continue;
                }
                if ("networkProfile".equals(fieldName)) {
                    deserializedBatchAccountProperties.networkProfile = NetworkProfile.fromJson(reader);
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List privateEndpointConnections;
                    deserializedBatchAccountProperties.privateEndpointConnections = privateEndpointConnections = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    continue;
                }
                if ("autoStorage".equals(fieldName)) {
                    deserializedBatchAccountProperties.autoStorage = AutoStorageProperties.fromJson(reader);
                    continue;
                }
                if ("encryption".equals(fieldName)) {
                    deserializedBatchAccountProperties.encryption = EncryptionProperties.fromJson(reader);
                    continue;
                }
                if ("dedicatedCoreQuota".equals(fieldName)) {
                    deserializedBatchAccountProperties.dedicatedCoreQuota = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("lowPriorityCoreQuota".equals(fieldName)) {
                    deserializedBatchAccountProperties.lowPriorityCoreQuota = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("dedicatedCoreQuotaPerVMFamily".equals(fieldName)) {
                    List dedicatedCoreQuotaPerVMFamily;
                    deserializedBatchAccountProperties.dedicatedCoreQuotaPerVMFamily = dedicatedCoreQuotaPerVMFamily = reader.readArray(reader1 -> VirtualMachineFamilyCoreQuota.fromJson(reader1));
                    continue;
                }
                if ("dedicatedCoreQuotaPerVMFamilyEnforced".equals(fieldName)) {
                    deserializedBatchAccountProperties.dedicatedCoreQuotaPerVMFamilyEnforced = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("poolQuota".equals(fieldName)) {
                    deserializedBatchAccountProperties.poolQuota = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("activeJobAndJobScheduleQuota".equals(fieldName)) {
                    deserializedBatchAccountProperties.activeJobAndJobScheduleQuota = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("allowedAuthenticationModes".equals(fieldName)) {
                    List allowedAuthenticationModes;
                    deserializedBatchAccountProperties.allowedAuthenticationModes = allowedAuthenticationModes = reader.readArray(reader1 -> AuthenticationMode.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBatchAccountProperties;
        });
    }
}

