/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.AuthenticationMode;
import com.azure.resourcemanager.batch.models.AutoStorageBaseProperties;
import com.azure.resourcemanager.batch.models.EncryptionProperties;
import com.azure.resourcemanager.batch.models.NetworkProfile;
import com.azure.resourcemanager.batch.models.PublicNetworkAccessType;
import java.io.IOException;
import java.util.List;

public final class BatchAccountUpdateProperties
implements JsonSerializable<BatchAccountUpdateProperties> {
    private AutoStorageBaseProperties autoStorage;
    private EncryptionProperties encryption;
    private List<AuthenticationMode> allowedAuthenticationModes;
    private PublicNetworkAccessType publicNetworkAccess;
    private NetworkProfile networkProfile;

    public AutoStorageBaseProperties autoStorage() {
        return this.autoStorage;
    }

    public BatchAccountUpdateProperties withAutoStorage(AutoStorageBaseProperties autoStorage) {
        this.autoStorage = autoStorage;
        return this;
    }

    public EncryptionProperties encryption() {
        return this.encryption;
    }

    public BatchAccountUpdateProperties withEncryption(EncryptionProperties encryption) {
        this.encryption = encryption;
        return this;
    }

    public List<AuthenticationMode> allowedAuthenticationModes() {
        return this.allowedAuthenticationModes;
    }

    public BatchAccountUpdateProperties withAllowedAuthenticationModes(List<AuthenticationMode> allowedAuthenticationModes) {
        this.allowedAuthenticationModes = allowedAuthenticationModes;
        return this;
    }

    public PublicNetworkAccessType publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public BatchAccountUpdateProperties withPublicNetworkAccess(PublicNetworkAccessType publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public NetworkProfile networkProfile() {
        return this.networkProfile;
    }

    public BatchAccountUpdateProperties withNetworkProfile(NetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    public void validate() {
        if (this.autoStorage() != null) {
            this.autoStorage().validate();
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.networkProfile() != null) {
            this.networkProfile().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("autoStorage", (JsonSerializable)this.autoStorage);
        jsonWriter.writeJsonField("encryption", (JsonSerializable)this.encryption);
        jsonWriter.writeArrayField("allowedAuthenticationModes", this.allowedAuthenticationModes, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeJsonField("networkProfile", (JsonSerializable)this.networkProfile);
        return jsonWriter.writeEndObject();
    }

    public static BatchAccountUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (BatchAccountUpdateProperties)jsonReader.readObject(reader -> {
            BatchAccountUpdateProperties deserializedBatchAccountUpdateProperties = new BatchAccountUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("autoStorage".equals(fieldName)) {
                    deserializedBatchAccountUpdateProperties.autoStorage = AutoStorageBaseProperties.fromJson(reader);
                    continue;
                }
                if ("encryption".equals(fieldName)) {
                    deserializedBatchAccountUpdateProperties.encryption = EncryptionProperties.fromJson(reader);
                    continue;
                }
                if ("allowedAuthenticationModes".equals(fieldName)) {
                    List allowedAuthenticationModes;
                    deserializedBatchAccountUpdateProperties.allowedAuthenticationModes = allowedAuthenticationModes = reader.readArray(reader1 -> AuthenticationMode.fromString(reader1.getString()));
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedBatchAccountUpdateProperties.publicNetworkAccess = PublicNetworkAccessType.fromString(reader.getString());
                    continue;
                }
                if ("networkProfile".equals(fieldName)) {
                    deserializedBatchAccountUpdateProperties.networkProfile = NetworkProfile.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBatchAccountUpdateProperties;
        });
    }
}

