/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.CertificateBaseProperties;
import com.azure.resourcemanager.batch.models.CertificateFormat;
import java.io.IOException;

public final class CertificateCreateOrUpdateProperties
extends CertificateBaseProperties {
    private String data;
    private String password;
    private static final ClientLogger LOGGER = new ClientLogger(CertificateCreateOrUpdateProperties.class);

    public String data() {
        return this.data;
    }

    public CertificateCreateOrUpdateProperties withData(String data) {
        this.data = data;
        return this;
    }

    public String password() {
        return this.password;
    }

    public CertificateCreateOrUpdateProperties withPassword(String password) {
        this.password = password;
        return this;
    }

    @Override
    public CertificateCreateOrUpdateProperties withThumbprintAlgorithm(String thumbprintAlgorithm) {
        super.withThumbprintAlgorithm(thumbprintAlgorithm);
        return this;
    }

    @Override
    public CertificateCreateOrUpdateProperties withThumbprint(String thumbprint) {
        super.withThumbprint(thumbprint);
        return this;
    }

    @Override
    public CertificateCreateOrUpdateProperties withFormat(CertificateFormat format) {
        super.withFormat(format);
        return this;
    }

    @Override
    public void validate() {
        if (this.data() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property data in model CertificateCreateOrUpdateProperties"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("thumbprintAlgorithm", this.thumbprintAlgorithm());
        jsonWriter.writeStringField("thumbprint", this.thumbprint());
        jsonWriter.writeStringField("format", this.format() == null ? null : this.format().toString());
        jsonWriter.writeStringField("data", this.data);
        jsonWriter.writeStringField("password", this.password);
        return jsonWriter.writeEndObject();
    }

    public static CertificateCreateOrUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CertificateCreateOrUpdateProperties)jsonReader.readObject(reader -> {
            CertificateCreateOrUpdateProperties deserializedCertificateCreateOrUpdateProperties = new CertificateCreateOrUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("thumbprintAlgorithm".equals(fieldName)) {
                    deserializedCertificateCreateOrUpdateProperties.withThumbprintAlgorithm(reader.getString());
                    continue;
                }
                if ("thumbprint".equals(fieldName)) {
                    deserializedCertificateCreateOrUpdateProperties.withThumbprint(reader.getString());
                    continue;
                }
                if ("format".equals(fieldName)) {
                    deserializedCertificateCreateOrUpdateProperties.withFormat(CertificateFormat.fromString(reader.getString()));
                    continue;
                }
                if ("data".equals(fieldName)) {
                    deserializedCertificateCreateOrUpdateProperties.data = reader.getString();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedCertificateCreateOrUpdateProperties.password = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCertificateCreateOrUpdateProperties;
        });
    }
}

