/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.fluent.models.CertificateProperties;
import com.azure.resourcemanager.batch.models.AzureProxyResource;
import com.azure.resourcemanager.batch.models.CertificateFormat;
import com.azure.resourcemanager.batch.models.CertificateProvisioningState;
import com.azure.resourcemanager.batch.models.DeleteCertificateError;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class CertificateInner
extends AzureProxyResource {
    private CertificateProperties innerProperties;
    private String etag;
    private String type;
    private String name;
    private String id;

    private CertificateProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String etag() {
        return this.etag;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public CertificateInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public CertificateProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public OffsetDateTime provisioningStateTransitionTime() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningStateTransitionTime();
    }

    public CertificateProvisioningState previousProvisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().previousProvisioningState();
    }

    public OffsetDateTime previousProvisioningStateTransitionTime() {
        return this.innerProperties() == null ? null : this.innerProperties().previousProvisioningStateTransitionTime();
    }

    public String publicData() {
        return this.innerProperties() == null ? null : this.innerProperties().publicData();
    }

    public DeleteCertificateError deleteCertificateError() {
        return this.innerProperties() == null ? null : this.innerProperties().deleteCertificateError();
    }

    public String thumbprintAlgorithm() {
        return this.innerProperties() == null ? null : this.innerProperties().thumbprintAlgorithm();
    }

    public CertificateInner withThumbprintAlgorithm(String thumbprintAlgorithm) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificateProperties();
        }
        this.innerProperties().withThumbprintAlgorithm(thumbprintAlgorithm);
        return this;
    }

    public String thumbprint() {
        return this.innerProperties() == null ? null : this.innerProperties().thumbprint();
    }

    public CertificateInner withThumbprint(String thumbprint) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificateProperties();
        }
        this.innerProperties().withThumbprint(thumbprint);
        return this;
    }

    public CertificateFormat format() {
        return this.innerProperties() == null ? null : this.innerProperties().format();
    }

    public CertificateInner withFormat(CertificateFormat format) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificateProperties();
        }
        this.innerProperties().withFormat(format);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static CertificateInner fromJson(JsonReader jsonReader) throws IOException {
        return (CertificateInner)((Object)jsonReader.readObject(reader -> {
            CertificateInner deserializedCertificateInner = new CertificateInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCertificateInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedCertificateInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCertificateInner.type = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedCertificateInner.etag = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedCertificateInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedCertificateInner.innerProperties = CertificateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCertificateInner;
        }));
    }
}

