/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.CertificateBaseProperties;
import com.azure.resourcemanager.batch.models.CertificateFormat;
import com.azure.resourcemanager.batch.models.CertificateProvisioningState;
import com.azure.resourcemanager.batch.models.DeleteCertificateError;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class CertificateProperties
extends CertificateBaseProperties {
    private CertificateProvisioningState provisioningState;
    private OffsetDateTime provisioningStateTransitionTime;
    private CertificateProvisioningState previousProvisioningState;
    private OffsetDateTime previousProvisioningStateTransitionTime;
    private String publicData;
    private DeleteCertificateError deleteCertificateError;

    public CertificateProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public OffsetDateTime provisioningStateTransitionTime() {
        return this.provisioningStateTransitionTime;
    }

    public CertificateProvisioningState previousProvisioningState() {
        return this.previousProvisioningState;
    }

    public OffsetDateTime previousProvisioningStateTransitionTime() {
        return this.previousProvisioningStateTransitionTime;
    }

    public String publicData() {
        return this.publicData;
    }

    public DeleteCertificateError deleteCertificateError() {
        return this.deleteCertificateError;
    }

    @Override
    public CertificateProperties withThumbprintAlgorithm(String thumbprintAlgorithm) {
        super.withThumbprintAlgorithm(thumbprintAlgorithm);
        return this;
    }

    @Override
    public CertificateProperties withThumbprint(String thumbprint) {
        super.withThumbprint(thumbprint);
        return this;
    }

    @Override
    public CertificateProperties withFormat(CertificateFormat format) {
        super.withFormat(format);
        return this;
    }

    @Override
    public void validate() {
        if (this.deleteCertificateError() != null) {
            this.deleteCertificateError().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("thumbprintAlgorithm", this.thumbprintAlgorithm());
        jsonWriter.writeStringField("thumbprint", this.thumbprint());
        jsonWriter.writeStringField("format", this.format() == null ? null : this.format().toString());
        return jsonWriter.writeEndObject();
    }

    public static CertificateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CertificateProperties)jsonReader.readObject(reader -> {
            CertificateProperties deserializedCertificateProperties = new CertificateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("thumbprintAlgorithm".equals(fieldName)) {
                    deserializedCertificateProperties.withThumbprintAlgorithm(reader.getString());
                    continue;
                }
                if ("thumbprint".equals(fieldName)) {
                    deserializedCertificateProperties.withThumbprint(reader.getString());
                    continue;
                }
                if ("format".equals(fieldName)) {
                    deserializedCertificateProperties.withFormat(CertificateFormat.fromString(reader.getString()));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedCertificateProperties.provisioningState = CertificateProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("provisioningStateTransitionTime".equals(fieldName)) {
                    deserializedCertificateProperties.provisioningStateTransitionTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("previousProvisioningState".equals(fieldName)) {
                    deserializedCertificateProperties.previousProvisioningState = CertificateProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("previousProvisioningStateTransitionTime".equals(fieldName)) {
                    deserializedCertificateProperties.previousProvisioningStateTransitionTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("publicData".equals(fieldName)) {
                    deserializedCertificateProperties.publicData = reader.getString();
                    continue;
                }
                if ("deleteCertificateError".equals(fieldName)) {
                    deserializedCertificateProperties.deleteCertificateError = DeleteCertificateError.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCertificateProperties;
        });
    }
}

