/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.fluent.models.DetectorResponseProperties;
import com.azure.resourcemanager.batch.models.AzureProxyResource;
import java.io.IOException;
import java.util.Map;

public final class DetectorResponseInner
extends AzureProxyResource {
    private DetectorResponseProperties innerProperties;
    private String etag;
    private String type;
    private String name;
    private String id;

    private DetectorResponseProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String etag() {
        return this.etag;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public DetectorResponseInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String value() {
        return this.innerProperties() == null ? null : this.innerProperties().value();
    }

    public DetectorResponseInner withValue(String value) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DetectorResponseProperties();
        }
        this.innerProperties().withValue(value);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static DetectorResponseInner fromJson(JsonReader jsonReader) throws IOException {
        return (DetectorResponseInner)((Object)jsonReader.readObject(reader -> {
            DetectorResponseInner deserializedDetectorResponseInner = new DetectorResponseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDetectorResponseInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDetectorResponseInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDetectorResponseInner.type = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedDetectorResponseInner.etag = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDetectorResponseInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDetectorResponseInner.innerProperties = DetectorResponseProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDetectorResponseInner;
        }));
    }
}

