/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.AllocationState;
import com.azure.resourcemanager.batch.models.ApplicationPackageReference;
import com.azure.resourcemanager.batch.models.AutoScaleRun;
import com.azure.resourcemanager.batch.models.CertificateReference;
import com.azure.resourcemanager.batch.models.DeploymentConfiguration;
import com.azure.resourcemanager.batch.models.InterNodeCommunicationState;
import com.azure.resourcemanager.batch.models.MetadataItem;
import com.azure.resourcemanager.batch.models.MountConfiguration;
import com.azure.resourcemanager.batch.models.NetworkConfiguration;
import com.azure.resourcemanager.batch.models.NodeCommunicationMode;
import com.azure.resourcemanager.batch.models.PoolProvisioningState;
import com.azure.resourcemanager.batch.models.ResizeOperationStatus;
import com.azure.resourcemanager.batch.models.ScaleSettings;
import com.azure.resourcemanager.batch.models.StartTask;
import com.azure.resourcemanager.batch.models.TaskSchedulingPolicy;
import com.azure.resourcemanager.batch.models.UpgradePolicy;
import com.azure.resourcemanager.batch.models.UserAccount;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class PoolProperties
implements JsonSerializable<PoolProperties> {
    private String displayName;
    private OffsetDateTime lastModified;
    private OffsetDateTime creationTime;
    private PoolProvisioningState provisioningState;
    private OffsetDateTime provisioningStateTransitionTime;
    private AllocationState allocationState;
    private OffsetDateTime allocationStateTransitionTime;
    private String vmSize;
    private DeploymentConfiguration deploymentConfiguration;
    private Integer currentDedicatedNodes;
    private Integer currentLowPriorityNodes;
    private ScaleSettings scaleSettings;
    private AutoScaleRun autoScaleRun;
    private InterNodeCommunicationState interNodeCommunication;
    private NetworkConfiguration networkConfiguration;
    private Integer taskSlotsPerNode;
    private TaskSchedulingPolicy taskSchedulingPolicy;
    private List<UserAccount> userAccounts;
    private List<MetadataItem> metadata;
    private StartTask startTask;
    private List<CertificateReference> certificates;
    private List<ApplicationPackageReference> applicationPackages;
    private List<String> applicationLicenses;
    private ResizeOperationStatus resizeOperationStatus;
    private List<MountConfiguration> mountConfiguration;
    private NodeCommunicationMode targetNodeCommunicationMode;
    private NodeCommunicationMode currentNodeCommunicationMode;
    private UpgradePolicy upgradePolicy;
    private Map<String, String> resourceTags;

    public String displayName() {
        return this.displayName;
    }

    public PoolProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public OffsetDateTime lastModified() {
        return this.lastModified;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public PoolProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public OffsetDateTime provisioningStateTransitionTime() {
        return this.provisioningStateTransitionTime;
    }

    public AllocationState allocationState() {
        return this.allocationState;
    }

    public OffsetDateTime allocationStateTransitionTime() {
        return this.allocationStateTransitionTime;
    }

    public String vmSize() {
        return this.vmSize;
    }

    public PoolProperties withVmSize(String vmSize) {
        this.vmSize = vmSize;
        return this;
    }

    public DeploymentConfiguration deploymentConfiguration() {
        return this.deploymentConfiguration;
    }

    public PoolProperties withDeploymentConfiguration(DeploymentConfiguration deploymentConfiguration) {
        this.deploymentConfiguration = deploymentConfiguration;
        return this;
    }

    public Integer currentDedicatedNodes() {
        return this.currentDedicatedNodes;
    }

    public Integer currentLowPriorityNodes() {
        return this.currentLowPriorityNodes;
    }

    public ScaleSettings scaleSettings() {
        return this.scaleSettings;
    }

    public PoolProperties withScaleSettings(ScaleSettings scaleSettings) {
        this.scaleSettings = scaleSettings;
        return this;
    }

    public AutoScaleRun autoScaleRun() {
        return this.autoScaleRun;
    }

    public InterNodeCommunicationState interNodeCommunication() {
        return this.interNodeCommunication;
    }

    public PoolProperties withInterNodeCommunication(InterNodeCommunicationState interNodeCommunication) {
        this.interNodeCommunication = interNodeCommunication;
        return this;
    }

    public NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public PoolProperties withNetworkConfiguration(NetworkConfiguration networkConfiguration) {
        this.networkConfiguration = networkConfiguration;
        return this;
    }

    public Integer taskSlotsPerNode() {
        return this.taskSlotsPerNode;
    }

    public PoolProperties withTaskSlotsPerNode(Integer taskSlotsPerNode) {
        this.taskSlotsPerNode = taskSlotsPerNode;
        return this;
    }

    public TaskSchedulingPolicy taskSchedulingPolicy() {
        return this.taskSchedulingPolicy;
    }

    public PoolProperties withTaskSchedulingPolicy(TaskSchedulingPolicy taskSchedulingPolicy) {
        this.taskSchedulingPolicy = taskSchedulingPolicy;
        return this;
    }

    public List<UserAccount> userAccounts() {
        return this.userAccounts;
    }

    public PoolProperties withUserAccounts(List<UserAccount> userAccounts) {
        this.userAccounts = userAccounts;
        return this;
    }

    public List<MetadataItem> metadata() {
        return this.metadata;
    }

    public PoolProperties withMetadata(List<MetadataItem> metadata) {
        this.metadata = metadata;
        return this;
    }

    public StartTask startTask() {
        return this.startTask;
    }

    public PoolProperties withStartTask(StartTask startTask) {
        this.startTask = startTask;
        return this;
    }

    public List<CertificateReference> certificates() {
        return this.certificates;
    }

    public PoolProperties withCertificates(List<CertificateReference> certificates) {
        this.certificates = certificates;
        return this;
    }

    public List<ApplicationPackageReference> applicationPackages() {
        return this.applicationPackages;
    }

    public PoolProperties withApplicationPackages(List<ApplicationPackageReference> applicationPackages) {
        this.applicationPackages = applicationPackages;
        return this;
    }

    public List<String> applicationLicenses() {
        return this.applicationLicenses;
    }

    public PoolProperties withApplicationLicenses(List<String> applicationLicenses) {
        this.applicationLicenses = applicationLicenses;
        return this;
    }

    public ResizeOperationStatus resizeOperationStatus() {
        return this.resizeOperationStatus;
    }

    public List<MountConfiguration> mountConfiguration() {
        return this.mountConfiguration;
    }

    public PoolProperties withMountConfiguration(List<MountConfiguration> mountConfiguration) {
        this.mountConfiguration = mountConfiguration;
        return this;
    }

    public NodeCommunicationMode targetNodeCommunicationMode() {
        return this.targetNodeCommunicationMode;
    }

    public PoolProperties withTargetNodeCommunicationMode(NodeCommunicationMode targetNodeCommunicationMode) {
        this.targetNodeCommunicationMode = targetNodeCommunicationMode;
        return this;
    }

    public NodeCommunicationMode currentNodeCommunicationMode() {
        return this.currentNodeCommunicationMode;
    }

    public UpgradePolicy upgradePolicy() {
        return this.upgradePolicy;
    }

    public PoolProperties withUpgradePolicy(UpgradePolicy upgradePolicy) {
        this.upgradePolicy = upgradePolicy;
        return this;
    }

    public Map<String, String> resourceTags() {
        return this.resourceTags;
    }

    public PoolProperties withResourceTags(Map<String, String> resourceTags) {
        this.resourceTags = resourceTags;
        return this;
    }

    public void validate() {
        if (this.deploymentConfiguration() != null) {
            this.deploymentConfiguration().validate();
        }
        if (this.scaleSettings() != null) {
            this.scaleSettings().validate();
        }
        if (this.autoScaleRun() != null) {
            this.autoScaleRun().validate();
        }
        if (this.networkConfiguration() != null) {
            this.networkConfiguration().validate();
        }
        if (this.taskSchedulingPolicy() != null) {
            this.taskSchedulingPolicy().validate();
        }
        if (this.userAccounts() != null) {
            this.userAccounts().forEach(e -> e.validate());
        }
        if (this.metadata() != null) {
            this.metadata().forEach(e -> e.validate());
        }
        if (this.startTask() != null) {
            this.startTask().validate();
        }
        if (this.certificates() != null) {
            this.certificates().forEach(e -> e.validate());
        }
        if (this.applicationPackages() != null) {
            this.applicationPackages().forEach(e -> e.validate());
        }
        if (this.resizeOperationStatus() != null) {
            this.resizeOperationStatus().validate();
        }
        if (this.mountConfiguration() != null) {
            this.mountConfiguration().forEach(e -> e.validate());
        }
        if (this.upgradePolicy() != null) {
            this.upgradePolicy().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("vmSize", this.vmSize);
        jsonWriter.writeJsonField("deploymentConfiguration", (JsonSerializable)this.deploymentConfiguration);
        jsonWriter.writeJsonField("scaleSettings", (JsonSerializable)this.scaleSettings);
        jsonWriter.writeStringField("interNodeCommunication", this.interNodeCommunication == null ? null : this.interNodeCommunication.toString());
        jsonWriter.writeJsonField("networkConfiguration", (JsonSerializable)this.networkConfiguration);
        jsonWriter.writeNumberField("taskSlotsPerNode", (Number)this.taskSlotsPerNode);
        jsonWriter.writeJsonField("taskSchedulingPolicy", (JsonSerializable)this.taskSchedulingPolicy);
        jsonWriter.writeArrayField("userAccounts", this.userAccounts, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("metadata", this.metadata, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("startTask", (JsonSerializable)this.startTask);
        jsonWriter.writeArrayField("certificates", this.certificates, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("applicationPackages", this.applicationPackages, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("applicationLicenses", this.applicationLicenses, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("mountConfiguration", this.mountConfiguration, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("targetNodeCommunicationMode", this.targetNodeCommunicationMode == null ? null : this.targetNodeCommunicationMode.toString());
        jsonWriter.writeJsonField("upgradePolicy", (JsonSerializable)this.upgradePolicy);
        jsonWriter.writeMapField("resourceTags", this.resourceTags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static PoolProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PoolProperties)jsonReader.readObject(reader -> {
            PoolProperties deserializedPoolProperties = new PoolProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("displayName".equals(fieldName)) {
                    deserializedPoolProperties.displayName = reader.getString();
                    continue;
                }
                if ("lastModified".equals(fieldName)) {
                    deserializedPoolProperties.lastModified = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedPoolProperties.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedPoolProperties.provisioningState = PoolProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("provisioningStateTransitionTime".equals(fieldName)) {
                    deserializedPoolProperties.provisioningStateTransitionTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("allocationState".equals(fieldName)) {
                    deserializedPoolProperties.allocationState = AllocationState.fromString(reader.getString());
                    continue;
                }
                if ("allocationStateTransitionTime".equals(fieldName)) {
                    deserializedPoolProperties.allocationStateTransitionTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("vmSize".equals(fieldName)) {
                    deserializedPoolProperties.vmSize = reader.getString();
                    continue;
                }
                if ("deploymentConfiguration".equals(fieldName)) {
                    deserializedPoolProperties.deploymentConfiguration = DeploymentConfiguration.fromJson(reader);
                    continue;
                }
                if ("currentDedicatedNodes".equals(fieldName)) {
                    deserializedPoolProperties.currentDedicatedNodes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("currentLowPriorityNodes".equals(fieldName)) {
                    deserializedPoolProperties.currentLowPriorityNodes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("scaleSettings".equals(fieldName)) {
                    deserializedPoolProperties.scaleSettings = ScaleSettings.fromJson(reader);
                    continue;
                }
                if ("autoScaleRun".equals(fieldName)) {
                    deserializedPoolProperties.autoScaleRun = AutoScaleRun.fromJson(reader);
                    continue;
                }
                if ("interNodeCommunication".equals(fieldName)) {
                    deserializedPoolProperties.interNodeCommunication = InterNodeCommunicationState.fromString(reader.getString());
                    continue;
                }
                if ("networkConfiguration".equals(fieldName)) {
                    deserializedPoolProperties.networkConfiguration = NetworkConfiguration.fromJson(reader);
                    continue;
                }
                if ("taskSlotsPerNode".equals(fieldName)) {
                    deserializedPoolProperties.taskSlotsPerNode = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("taskSchedulingPolicy".equals(fieldName)) {
                    deserializedPoolProperties.taskSchedulingPolicy = TaskSchedulingPolicy.fromJson(reader);
                    continue;
                }
                if ("userAccounts".equals(fieldName)) {
                    List userAccounts;
                    deserializedPoolProperties.userAccounts = userAccounts = reader.readArray(reader1 -> UserAccount.fromJson(reader1));
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    List metadata;
                    deserializedPoolProperties.metadata = metadata = reader.readArray(reader1 -> MetadataItem.fromJson(reader1));
                    continue;
                }
                if ("startTask".equals(fieldName)) {
                    deserializedPoolProperties.startTask = StartTask.fromJson(reader);
                    continue;
                }
                if ("certificates".equals(fieldName)) {
                    List certificates;
                    deserializedPoolProperties.certificates = certificates = reader.readArray(reader1 -> CertificateReference.fromJson(reader1));
                    continue;
                }
                if ("applicationPackages".equals(fieldName)) {
                    List applicationPackages;
                    deserializedPoolProperties.applicationPackages = applicationPackages = reader.readArray(reader1 -> ApplicationPackageReference.fromJson(reader1));
                    continue;
                }
                if ("applicationLicenses".equals(fieldName)) {
                    List applicationLicenses;
                    deserializedPoolProperties.applicationLicenses = applicationLicenses = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("resizeOperationStatus".equals(fieldName)) {
                    deserializedPoolProperties.resizeOperationStatus = ResizeOperationStatus.fromJson(reader);
                    continue;
                }
                if ("mountConfiguration".equals(fieldName)) {
                    List mountConfiguration;
                    deserializedPoolProperties.mountConfiguration = mountConfiguration = reader.readArray(reader1 -> MountConfiguration.fromJson(reader1));
                    continue;
                }
                if ("targetNodeCommunicationMode".equals(fieldName)) {
                    deserializedPoolProperties.targetNodeCommunicationMode = NodeCommunicationMode.fromString(reader.getString());
                    continue;
                }
                if ("currentNodeCommunicationMode".equals(fieldName)) {
                    deserializedPoolProperties.currentNodeCommunicationMode = NodeCommunicationMode.fromString(reader.getString());
                    continue;
                }
                if ("upgradePolicy".equals(fieldName)) {
                    deserializedPoolProperties.upgradePolicy = UpgradePolicy.fromJson(reader);
                    continue;
                }
                if ("resourceTags".equals(fieldName)) {
                    Map resourceTags;
                    deserializedPoolProperties.resourceTags = resourceTags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPoolProperties;
        });
    }
}

