/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.PrivateEndpoint;
import com.azure.resourcemanager.batch.models.PrivateEndpointConnectionProvisioningState;
import com.azure.resourcemanager.batch.models.PrivateLinkServiceConnectionState;
import java.io.IOException;
import java.util.List;

public final class PrivateEndpointConnectionProperties
implements JsonSerializable<PrivateEndpointConnectionProperties> {
    private PrivateEndpointConnectionProvisioningState provisioningState;
    private PrivateEndpoint privateEndpoint;
    private List<String> groupIds;
    private PrivateLinkServiceConnectionState privateLinkServiceConnectionState;

    public PrivateEndpointConnectionProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public PrivateEndpoint privateEndpoint() {
        return this.privateEndpoint;
    }

    public List<String> groupIds() {
        return this.groupIds;
    }

    public PrivateLinkServiceConnectionState privateLinkServiceConnectionState() {
        return this.privateLinkServiceConnectionState;
    }

    public PrivateEndpointConnectionProperties withPrivateLinkServiceConnectionState(PrivateLinkServiceConnectionState privateLinkServiceConnectionState) {
        this.privateLinkServiceConnectionState = privateLinkServiceConnectionState;
        return this;
    }

    public void validate() {
        if (this.privateEndpoint() != null) {
            this.privateEndpoint().validate();
        }
        if (this.privateLinkServiceConnectionState() != null) {
            this.privateLinkServiceConnectionState().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("privateLinkServiceConnectionState", (JsonSerializable)this.privateLinkServiceConnectionState);
        return jsonWriter.writeEndObject();
    }

    public static PrivateEndpointConnectionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PrivateEndpointConnectionProperties)jsonReader.readObject(reader -> {
            PrivateEndpointConnectionProperties deserializedPrivateEndpointConnectionProperties = new PrivateEndpointConnectionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedPrivateEndpointConnectionProperties.provisioningState = PrivateEndpointConnectionProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("privateEndpoint".equals(fieldName)) {
                    deserializedPrivateEndpointConnectionProperties.privateEndpoint = PrivateEndpoint.fromJson(reader);
                    continue;
                }
                if ("groupIds".equals(fieldName)) {
                    List groupIds;
                    deserializedPrivateEndpointConnectionProperties.groupIds = groupIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("privateLinkServiceConnectionState".equals(fieldName)) {
                    deserializedPrivateEndpointConnectionProperties.privateLinkServiceConnectionState = PrivateLinkServiceConnectionState.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPrivateEndpointConnectionProperties;
        });
    }
}

