/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.fluent.models.PrivateLinkResourceProperties;
import com.azure.resourcemanager.batch.models.AzureProxyResource;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class PrivateLinkResourceInner
extends AzureProxyResource {
    private PrivateLinkResourceProperties innerProperties;
    private String etag;
    private String type;
    private String name;
    private String id;

    private PrivateLinkResourceProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String etag() {
        return this.etag;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public PrivateLinkResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String groupId() {
        return this.innerProperties() == null ? null : this.innerProperties().groupId();
    }

    public List<String> requiredMembers() {
        return this.innerProperties() == null ? null : this.innerProperties().requiredMembers();
    }

    public List<String> requiredZoneNames() {
        return this.innerProperties() == null ? null : this.innerProperties().requiredZoneNames();
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static PrivateLinkResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (PrivateLinkResourceInner)((Object)jsonReader.readObject(reader -> {
            PrivateLinkResourceInner deserializedPrivateLinkResourceInner = new PrivateLinkResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedPrivateLinkResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedPrivateLinkResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedPrivateLinkResourceInner.type = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedPrivateLinkResourceInner.etag = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedPrivateLinkResourceInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedPrivateLinkResourceInner.innerProperties = PrivateLinkResourceProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPrivateLinkResourceInner;
        }));
    }
}

