/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.SkuCapability;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class SupportedSkuInner
implements JsonSerializable<SupportedSkuInner> {
    private String name;
    private String familyName;
    private List<SkuCapability> capabilities;
    private OffsetDateTime batchSupportEndOfLife;

    public String name() {
        return this.name;
    }

    public String familyName() {
        return this.familyName;
    }

    public List<SkuCapability> capabilities() {
        return this.capabilities;
    }

    public OffsetDateTime batchSupportEndOfLife() {
        return this.batchSupportEndOfLife;
    }

    public void validate() {
        if (this.capabilities() != null) {
            this.capabilities().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static SupportedSkuInner fromJson(JsonReader jsonReader) throws IOException {
        return (SupportedSkuInner)jsonReader.readObject(reader -> {
            SupportedSkuInner deserializedSupportedSkuInner = new SupportedSkuInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedSupportedSkuInner.name = reader.getString();
                    continue;
                }
                if ("familyName".equals(fieldName)) {
                    deserializedSupportedSkuInner.familyName = reader.getString();
                    continue;
                }
                if ("capabilities".equals(fieldName)) {
                    List capabilities;
                    deserializedSupportedSkuInner.capabilities = capabilities = reader.readArray(reader1 -> SkuCapability.fromJson(reader1));
                    continue;
                }
                if ("batchSupportEndOfLife".equals(fieldName)) {
                    deserializedSupportedSkuInner.batchSupportEndOfLife = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSupportedSkuInner;
        });
    }
}

