/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.batch.BatchManager;
import com.azure.resourcemanager.batch.fluent.models.ApplicationInner;
import com.azure.resourcemanager.batch.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.batch.models.Application;
import java.util.Collections;
import java.util.Map;

public final class ApplicationImpl
implements Application,
Application.Definition,
Application.Update {
    private ApplicationInner innerObject;
    private final BatchManager serviceManager;
    private String resourceGroupName;
    private String accountName;
    private String applicationName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public Map<String, String> tags() {
        Map<String, String> inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String displayName() {
        return this.innerModel().displayName();
    }

    @Override
    public Boolean allowUpdates() {
        return this.innerModel().allowUpdates();
    }

    @Override
    public String defaultVersion() {
        return this.innerModel().defaultVersion();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ApplicationInner innerModel() {
        return this.innerObject;
    }

    private BatchManager manager() {
        return this.serviceManager;
    }

    @Override
    public ApplicationImpl withExistingBatchAccount(String resourceGroupName, String accountName) {
        this.resourceGroupName = resourceGroupName;
        this.accountName = accountName;
        return this;
    }

    @Override
    public Application create() {
        this.innerObject = (ApplicationInner)((Object)this.serviceManager.serviceClient().getApplications().createWithResponse(this.resourceGroupName, this.accountName, this.applicationName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public Application create(Context context) {
        this.innerObject = (ApplicationInner)((Object)this.serviceManager.serviceClient().getApplications().createWithResponse(this.resourceGroupName, this.accountName, this.applicationName, this.innerModel(), context).getValue());
        return this;
    }

    ApplicationImpl(String name, BatchManager serviceManager) {
        this.innerObject = new ApplicationInner();
        this.serviceManager = serviceManager;
        this.applicationName = name;
    }

    @Override
    public ApplicationImpl update() {
        return this;
    }

    @Override
    public Application apply() {
        this.innerObject = (ApplicationInner)((Object)this.serviceManager.serviceClient().getApplications().updateWithResponse(this.resourceGroupName, this.accountName, this.applicationName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public Application apply(Context context) {
        this.innerObject = (ApplicationInner)((Object)this.serviceManager.serviceClient().getApplications().updateWithResponse(this.resourceGroupName, this.accountName, this.applicationName, this.innerModel(), context).getValue());
        return this;
    }

    ApplicationImpl(ApplicationInner innerObject, BatchManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.accountName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "batchAccounts");
        this.applicationName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "applications");
    }

    @Override
    public Application refresh() {
        this.innerObject = (ApplicationInner)((Object)this.serviceManager.serviceClient().getApplications().getWithResponse(this.resourceGroupName, this.accountName, this.applicationName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Application refresh(Context context) {
        this.innerObject = (ApplicationInner)((Object)this.serviceManager.serviceClient().getApplications().getWithResponse(this.resourceGroupName, this.accountName, this.applicationName, context).getValue());
        return this;
    }

    @Override
    public ApplicationImpl withTags(Map<String, String> tags) {
        this.innerModel().withTags((Map)tags);
        return this;
    }

    @Override
    public ApplicationImpl withDisplayName(String displayName) {
        this.innerModel().withDisplayName(displayName);
        return this;
    }

    @Override
    public ApplicationImpl withAllowUpdates(Boolean allowUpdates) {
        this.innerModel().withAllowUpdates(allowUpdates);
        return this;
    }

    @Override
    public ApplicationImpl withDefaultVersion(String defaultVersion) {
        this.innerModel().withDefaultVersion(defaultVersion);
        return this;
    }
}

