/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.batch.BatchManager;
import com.azure.resourcemanager.batch.fluent.ApplicationsClient;
import com.azure.resourcemanager.batch.fluent.models.ApplicationInner;
import com.azure.resourcemanager.batch.implementation.ApplicationImpl;
import com.azure.resourcemanager.batch.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.batch.models.Application;
import com.azure.resourcemanager.batch.models.Applications;

public final class ApplicationsImpl
implements Applications {
    private static final ClientLogger LOGGER = new ClientLogger(ApplicationsImpl.class);
    private final ApplicationsClient innerClient;
    private final BatchManager serviceManager;

    public ApplicationsImpl(ApplicationsClient innerClient, BatchManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String accountName, String applicationName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, accountName, applicationName, context);
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String applicationName) {
        this.serviceClient().delete(resourceGroupName, accountName, applicationName);
    }

    @Override
    public Response<Application> getWithResponse(String resourceGroupName, String accountName, String applicationName, Context context) {
        Response<ApplicationInner> inner = this.serviceClient().getWithResponse(resourceGroupName, accountName, applicationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ApplicationImpl((ApplicationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Application get(String resourceGroupName, String accountName, String applicationName) {
        ApplicationInner inner = this.serviceClient().get(resourceGroupName, accountName, applicationName);
        if (inner != null) {
            return new ApplicationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<Application> list(String resourceGroupName, String accountName) {
        PagedIterable<ApplicationInner> inner = this.serviceClient().list(resourceGroupName, accountName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApplicationImpl((ApplicationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Application> list(String resourceGroupName, String accountName, Integer maxresults, Context context) {
        PagedIterable<ApplicationInner> inner = this.serviceClient().list(resourceGroupName, accountName, maxresults, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApplicationImpl((ApplicationInner)((Object)inner1), this.manager()));
    }

    @Override
    public Application getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "batchAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'batchAccounts'.", id)));
        }
        String applicationName = ResourceManagerUtils.getValueFromIdByName(id, "applications");
        if (applicationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'applications'.", id)));
        }
        return (Application)this.getWithResponse(resourceGroupName, accountName, applicationName, Context.NONE).getValue();
    }

    @Override
    public Response<Application> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "batchAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'batchAccounts'.", id)));
        }
        String applicationName = ResourceManagerUtils.getValueFromIdByName(id, "applications");
        if (applicationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'applications'.", id)));
        }
        return this.getWithResponse(resourceGroupName, accountName, applicationName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "batchAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'batchAccounts'.", id)));
        }
        String applicationName = ResourceManagerUtils.getValueFromIdByName(id, "applications");
        if (applicationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'applications'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, accountName, applicationName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "batchAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'batchAccounts'.", id)));
        }
        String applicationName = ResourceManagerUtils.getValueFromIdByName(id, "applications");
        if (applicationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'applications'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, accountName, applicationName, context);
    }

    private ApplicationsClient serviceClient() {
        return this.innerClient;
    }

    private BatchManager manager() {
        return this.serviceManager;
    }

    @Override
    public ApplicationImpl define(String name) {
        return new ApplicationImpl(name, this.manager());
    }
}

