/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.management.polling.PollerFactory;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.batch.fluent.ApplicationPackagesClient;
import com.azure.resourcemanager.batch.fluent.ApplicationsClient;
import com.azure.resourcemanager.batch.fluent.BatchAccountsClient;
import com.azure.resourcemanager.batch.fluent.BatchManagementClient;
import com.azure.resourcemanager.batch.fluent.CertificatesClient;
import com.azure.resourcemanager.batch.fluent.LocationsClient;
import com.azure.resourcemanager.batch.fluent.NetworkSecurityPerimetersClient;
import com.azure.resourcemanager.batch.fluent.OperationsClient;
import com.azure.resourcemanager.batch.fluent.PoolsClient;
import com.azure.resourcemanager.batch.fluent.PrivateEndpointConnectionsClient;
import com.azure.resourcemanager.batch.fluent.PrivateLinkResourcesClient;
import com.azure.resourcemanager.batch.implementation.ApplicationPackagesClientImpl;
import com.azure.resourcemanager.batch.implementation.ApplicationsClientImpl;
import com.azure.resourcemanager.batch.implementation.BatchAccountsClientImpl;
import com.azure.resourcemanager.batch.implementation.BatchManagementClientBuilder;
import com.azure.resourcemanager.batch.implementation.CertificatesClientImpl;
import com.azure.resourcemanager.batch.implementation.LocationsClientImpl;
import com.azure.resourcemanager.batch.implementation.NetworkSecurityPerimetersClientImpl;
import com.azure.resourcemanager.batch.implementation.OperationsClientImpl;
import com.azure.resourcemanager.batch.implementation.PoolsClientImpl;
import com.azure.resourcemanager.batch.implementation.PrivateEndpointConnectionsClientImpl;
import com.azure.resourcemanager.batch.implementation.PrivateLinkResourcesClientImpl;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=BatchManagementClientBuilder.class)
public final class BatchManagementClientImpl
implements BatchManagementClient {
    private final String subscriptionId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final BatchAccountsClient batchAccounts;
    private final ApplicationPackagesClient applicationPackages;
    private final ApplicationsClient applications;
    private final LocationsClient locations;
    private final OperationsClient operations;
    private final CertificatesClient certificates;
    private final PrivateLinkResourcesClient privateLinkResources;
    private final PrivateEndpointConnectionsClient privateEndpointConnections;
    private final PoolsClient pools;
    private final NetworkSecurityPerimetersClient networkSecurityPerimeters;
    private static final ClientLogger LOGGER = new ClientLogger(BatchManagementClientImpl.class);

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public BatchAccountsClient getBatchAccounts() {
        return this.batchAccounts;
    }

    @Override
    public ApplicationPackagesClient getApplicationPackages() {
        return this.applicationPackages;
    }

    @Override
    public ApplicationsClient getApplications() {
        return this.applications;
    }

    @Override
    public LocationsClient getLocations() {
        return this.locations;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public CertificatesClient getCertificates() {
        return this.certificates;
    }

    @Override
    public PrivateLinkResourcesClient getPrivateLinkResources() {
        return this.privateLinkResources;
    }

    @Override
    public PrivateEndpointConnectionsClient getPrivateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    @Override
    public PoolsClient getPools() {
        return this.pools;
    }

    @Override
    public NetworkSecurityPerimetersClient getNetworkSecurityPerimeters() {
        return this.networkSecurityPerimeters;
    }

    BatchManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2024-07-01";
        this.batchAccounts = new BatchAccountsClientImpl(this);
        this.applicationPackages = new ApplicationPackagesClientImpl(this);
        this.applications = new ApplicationsClientImpl(this);
        this.locations = new LocationsClientImpl(this);
        this.operations = new OperationsClientImpl(this);
        this.certificates = new CertificatesClientImpl(this);
        this.privateLinkResources = new PrivateLinkResourcesClientImpl(this);
        this.privateEndpointConnections = new PrivateEndpointConnectionsClientImpl(this);
        this.pools = new PoolsClientImpl(this);
        this.networkSecurityPerimeters = new NetworkSecurityPerimetersClientImpl(this);
    }

    public Context getContext() {
        return Context.NONE;
    }

    public Context mergeContext(Context context) {
        return CoreUtils.mergeContexts((Context)this.getContext(), (Context)context);
    }

    public <T, U> PollerFlux<PollResult<T>, U> getLroResult(Mono<Response<Flux<ByteBuffer>>> activationResponse, HttpPipeline httpPipeline, Type pollResultType, Type finalResultType, Context context) {
        return PollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, activationResponse, (Context)context);
    }

    public <T, U> Mono<U> getLroFinalResultOrError(AsyncPollResponse<PollResult<T>, U> response) {
        if (response.getStatus() != LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
            String errorMessage;
            ManagementError managementError = null;
            HttpResponseImpl errorResponse = null;
            PollResult.Error lroError = ((PollResult)response.getValue()).getError();
            if (lroError != null) {
                errorResponse = new HttpResponseImpl(lroError.getResponseStatusCode(), lroError.getResponseHeaders(), lroError.getResponseBody());
                errorMessage = ((PollResult)response.getValue()).getError().getMessage();
                String errorBody = ((PollResult)response.getValue()).getError().getResponseBody();
                if (errorBody != null) {
                    try {
                        managementError = (ManagementError)this.getSerializerAdapter().deserialize(errorBody, ManagementError.class, SerializerEncoding.JSON);
                        if (managementError.getCode() == null || managementError.getMessage() == null) {
                            managementError = null;
                        }
                    }
                    catch (IOException | RuntimeException ioe) {
                        LOGGER.logThrowableAsWarning((Throwable)ioe);
                    }
                }
            } else {
                errorMessage = "Long running operation failed.";
            }
            if (managementError == null) {
                managementError = new ManagementError(response.getStatus().toString(), errorMessage);
            }
            return Mono.error((Throwable)new ManagementException(errorMessage, (HttpResponse)errorResponse, managementError));
        }
        return response.getFinalResult();
    }

    private static final class HttpResponseImpl
    extends HttpResponse {
        private final int statusCode;
        private final byte[] responseBody;
        private final HttpHeaders httpHeaders;

        HttpResponseImpl(int statusCode, HttpHeaders httpHeaders, String responseBody) {
            super(null);
            this.statusCode = statusCode;
            this.httpHeaders = httpHeaders;
            this.responseBody = responseBody == null ? null : responseBody.getBytes(StandardCharsets.UTF_8);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String s) {
            return this.httpHeaders.getValue(HttpHeaderName.fromString((String)s));
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.just((Object)ByteBuffer.wrap(this.responseBody));
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just((Object)this.responseBody);
        }

        public Mono<String> getBodyAsString() {
            return Mono.just((Object)new String(this.responseBody, StandardCharsets.UTF_8));
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just((Object)new String(this.responseBody, charset));
        }
    }
}

