/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.batch.BatchManager;
import com.azure.resourcemanager.batch.fluent.LocationsClient;
import com.azure.resourcemanager.batch.fluent.models.BatchLocationQuotaInner;
import com.azure.resourcemanager.batch.fluent.models.CheckNameAvailabilityResultInner;
import com.azure.resourcemanager.batch.fluent.models.SupportedSkuInner;
import com.azure.resourcemanager.batch.implementation.BatchLocationQuotaImpl;
import com.azure.resourcemanager.batch.implementation.CheckNameAvailabilityResultImpl;
import com.azure.resourcemanager.batch.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.batch.implementation.SupportedSkuImpl;
import com.azure.resourcemanager.batch.models.BatchLocationQuota;
import com.azure.resourcemanager.batch.models.CheckNameAvailabilityParameters;
import com.azure.resourcemanager.batch.models.CheckNameAvailabilityResult;
import com.azure.resourcemanager.batch.models.Locations;
import com.azure.resourcemanager.batch.models.SupportedSku;

public final class LocationsImpl
implements Locations {
    private static final ClientLogger LOGGER = new ClientLogger(LocationsImpl.class);
    private final LocationsClient innerClient;
    private final BatchManager serviceManager;

    public LocationsImpl(LocationsClient innerClient, BatchManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<BatchLocationQuota> getQuotasWithResponse(String locationName, Context context) {
        Response<BatchLocationQuotaInner> inner = this.serviceClient().getQuotasWithResponse(locationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new BatchLocationQuotaImpl((BatchLocationQuotaInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public BatchLocationQuota getQuotas(String locationName) {
        BatchLocationQuotaInner inner = this.serviceClient().getQuotas(locationName);
        if (inner != null) {
            return new BatchLocationQuotaImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<SupportedSku> listSupportedVirtualMachineSkus(String locationName) {
        PagedIterable<SupportedSkuInner> inner = this.serviceClient().listSupportedVirtualMachineSkus(locationName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SupportedSkuImpl((SupportedSkuInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<SupportedSku> listSupportedVirtualMachineSkus(String locationName, Integer maxresults, String filter, Context context) {
        PagedIterable<SupportedSkuInner> inner = this.serviceClient().listSupportedVirtualMachineSkus(locationName, maxresults, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SupportedSkuImpl((SupportedSkuInner)inner1, this.manager()));
    }

    @Override
    public Response<CheckNameAvailabilityResult> checkNameAvailabilityWithResponse(String locationName, CheckNameAvailabilityParameters parameters, Context context) {
        Response<CheckNameAvailabilityResultInner> inner = this.serviceClient().checkNameAvailabilityWithResponse(locationName, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CheckNameAvailabilityResultImpl((CheckNameAvailabilityResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public CheckNameAvailabilityResult checkNameAvailability(String locationName, CheckNameAvailabilityParameters parameters) {
        CheckNameAvailabilityResultInner inner = this.serviceClient().checkNameAvailability(locationName, parameters);
        if (inner != null) {
            return new CheckNameAvailabilityResultImpl(inner, this.manager());
        }
        return null;
    }

    private LocationsClient serviceClient() {
        return this.innerClient;
    }

    private BatchManager manager() {
        return this.serviceManager;
    }
}

