/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.batch.BatchManager;
import com.azure.resourcemanager.batch.fluent.NetworkSecurityPerimetersClient;
import com.azure.resourcemanager.batch.fluent.models.NetworkSecurityPerimeterConfigurationInner;
import com.azure.resourcemanager.batch.implementation.NetworkSecurityPerimeterConfigurationImpl;
import com.azure.resourcemanager.batch.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.batch.models.NetworkSecurityPerimeterConfiguration;
import com.azure.resourcemanager.batch.models.NetworkSecurityPerimeters;

public final class NetworkSecurityPerimetersImpl
implements NetworkSecurityPerimeters {
    private static final ClientLogger LOGGER = new ClientLogger(NetworkSecurityPerimetersImpl.class);
    private final NetworkSecurityPerimetersClient innerClient;
    private final BatchManager serviceManager;

    public NetworkSecurityPerimetersImpl(NetworkSecurityPerimetersClient innerClient, BatchManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<NetworkSecurityPerimeterConfiguration> listConfigurations(String resourceGroupName, String accountName) {
        PagedIterable<NetworkSecurityPerimeterConfigurationInner> inner = this.serviceClient().listConfigurations(resourceGroupName, accountName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new NetworkSecurityPerimeterConfigurationImpl((NetworkSecurityPerimeterConfigurationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<NetworkSecurityPerimeterConfiguration> listConfigurations(String resourceGroupName, String accountName, Context context) {
        PagedIterable<NetworkSecurityPerimeterConfigurationInner> inner = this.serviceClient().listConfigurations(resourceGroupName, accountName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new NetworkSecurityPerimeterConfigurationImpl((NetworkSecurityPerimeterConfigurationInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<NetworkSecurityPerimeterConfiguration> getConfigurationWithResponse(String resourceGroupName, String accountName, String networkSecurityPerimeterConfigurationName, Context context) {
        Response<NetworkSecurityPerimeterConfigurationInner> inner = this.serviceClient().getConfigurationWithResponse(resourceGroupName, accountName, networkSecurityPerimeterConfigurationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new NetworkSecurityPerimeterConfigurationImpl((NetworkSecurityPerimeterConfigurationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public NetworkSecurityPerimeterConfiguration getConfiguration(String resourceGroupName, String accountName, String networkSecurityPerimeterConfigurationName) {
        NetworkSecurityPerimeterConfigurationInner inner = this.serviceClient().getConfiguration(resourceGroupName, accountName, networkSecurityPerimeterConfigurationName);
        if (inner != null) {
            return new NetworkSecurityPerimeterConfigurationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void reconcileConfiguration(String resourceGroupName, String accountName, String networkSecurityPerimeterConfigurationName) {
        this.serviceClient().reconcileConfiguration(resourceGroupName, accountName, networkSecurityPerimeterConfigurationName);
    }

    @Override
    public void reconcileConfiguration(String resourceGroupName, String accountName, String networkSecurityPerimeterConfigurationName, Context context) {
        this.serviceClient().reconcileConfiguration(resourceGroupName, accountName, networkSecurityPerimeterConfigurationName, context);
    }

    private NetworkSecurityPerimetersClient serviceClient() {
        return this.innerClient;
    }

    private BatchManager manager() {
        return this.serviceManager;
    }
}

