/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.batch.BatchManager;
import com.azure.resourcemanager.batch.fluent.PoolsClient;
import com.azure.resourcemanager.batch.fluent.models.PoolInner;
import com.azure.resourcemanager.batch.implementation.PoolImpl;
import com.azure.resourcemanager.batch.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.batch.models.Pool;
import com.azure.resourcemanager.batch.models.Pools;
import com.azure.resourcemanager.batch.models.PoolsDisableAutoScaleResponse;
import com.azure.resourcemanager.batch.models.PoolsGetResponse;
import com.azure.resourcemanager.batch.models.PoolsStopResizeResponse;

public final class PoolsImpl
implements Pools {
    private static final ClientLogger LOGGER = new ClientLogger(PoolsImpl.class);
    private final PoolsClient innerClient;
    private final BatchManager serviceManager;

    public PoolsImpl(PoolsClient innerClient, BatchManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Pool> listByBatchAccount(String resourceGroupName, String accountName) {
        PagedIterable<PoolInner> inner = this.serviceClient().listByBatchAccount(resourceGroupName, accountName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PoolImpl((PoolInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Pool> listByBatchAccount(String resourceGroupName, String accountName, Integer maxresults, String select, String filter, Context context) {
        PagedIterable<PoolInner> inner = this.serviceClient().listByBatchAccount(resourceGroupName, accountName, maxresults, select, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PoolImpl((PoolInner)((Object)inner1), this.manager()));
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String poolName) {
        this.serviceClient().delete(resourceGroupName, accountName, poolName);
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String poolName, Context context) {
        this.serviceClient().delete(resourceGroupName, accountName, poolName, context);
    }

    @Override
    public Response<Pool> getWithResponse(String resourceGroupName, String accountName, String poolName, Context context) {
        PoolsGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, accountName, poolName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PoolImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public Pool get(String resourceGroupName, String accountName, String poolName) {
        PoolInner inner = this.serviceClient().get(resourceGroupName, accountName, poolName);
        if (inner != null) {
            return new PoolImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Pool> disableAutoScaleWithResponse(String resourceGroupName, String accountName, String poolName, Context context) {
        PoolsDisableAutoScaleResponse inner = this.serviceClient().disableAutoScaleWithResponse(resourceGroupName, accountName, poolName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PoolImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public Pool disableAutoScale(String resourceGroupName, String accountName, String poolName) {
        PoolInner inner = this.serviceClient().disableAutoScale(resourceGroupName, accountName, poolName);
        if (inner != null) {
            return new PoolImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Pool> stopResizeWithResponse(String resourceGroupName, String accountName, String poolName, Context context) {
        PoolsStopResizeResponse inner = this.serviceClient().stopResizeWithResponse(resourceGroupName, accountName, poolName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PoolImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public Pool stopResize(String resourceGroupName, String accountName, String poolName) {
        PoolInner inner = this.serviceClient().stopResize(resourceGroupName, accountName, poolName);
        if (inner != null) {
            return new PoolImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Pool getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "batchAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'batchAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "pools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'pools'.", id)));
        }
        return (Pool)this.getWithResponse(resourceGroupName, accountName, poolName, Context.NONE).getValue();
    }

    @Override
    public Response<Pool> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "batchAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'batchAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "pools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'pools'.", id)));
        }
        return this.getWithResponse(resourceGroupName, accountName, poolName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "batchAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'batchAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "pools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'pools'.", id)));
        }
        this.delete(resourceGroupName, accountName, poolName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "batchAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'batchAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "pools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'pools'.", id)));
        }
        this.delete(resourceGroupName, accountName, poolName, context);
    }

    private PoolsClient serviceClient() {
        return this.innerClient;
    }

    private BatchManager manager() {
        return this.serviceManager;
    }

    @Override
    public PoolImpl define(String name) {
        return new PoolImpl(name, this.manager());
    }
}

