/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.batch.BatchManager;
import com.azure.resourcemanager.batch.fluent.PrivateLinkResourcesClient;
import com.azure.resourcemanager.batch.fluent.models.PrivateLinkResourceInner;
import com.azure.resourcemanager.batch.implementation.PrivateLinkResourceImpl;
import com.azure.resourcemanager.batch.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.batch.models.PrivateLinkResource;
import com.azure.resourcemanager.batch.models.PrivateLinkResources;

public final class PrivateLinkResourcesImpl
implements PrivateLinkResources {
    private static final ClientLogger LOGGER = new ClientLogger(PrivateLinkResourcesImpl.class);
    private final PrivateLinkResourcesClient innerClient;
    private final BatchManager serviceManager;

    public PrivateLinkResourcesImpl(PrivateLinkResourcesClient innerClient, BatchManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<PrivateLinkResource> listByBatchAccount(String resourceGroupName, String accountName) {
        PagedIterable<PrivateLinkResourceInner> inner = this.serviceClient().listByBatchAccount(resourceGroupName, accountName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PrivateLinkResourceImpl((PrivateLinkResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PrivateLinkResource> listByBatchAccount(String resourceGroupName, String accountName, Integer maxresults, Context context) {
        PagedIterable<PrivateLinkResourceInner> inner = this.serviceClient().listByBatchAccount(resourceGroupName, accountName, maxresults, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PrivateLinkResourceImpl((PrivateLinkResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<PrivateLinkResource> getWithResponse(String resourceGroupName, String accountName, String privateLinkResourceName, Context context) {
        Response<PrivateLinkResourceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, accountName, privateLinkResourceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PrivateLinkResourceImpl((PrivateLinkResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public PrivateLinkResource get(String resourceGroupName, String accountName, String privateLinkResourceName) {
        PrivateLinkResourceInner inner = this.serviceClient().get(resourceGroupName, accountName, privateLinkResourceName);
        if (inner != null) {
            return new PrivateLinkResourceImpl(inner, this.manager());
        }
        return null;
    }

    private PrivateLinkResourcesClient serviceClient() {
        return this.innerClient;
    }

    private BatchManager manager() {
        return this.serviceManager;
    }
}

