/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.batch.fluent.models.ApplicationInner;
import java.util.Map;

public interface Application {
    public String id();

    public String name();

    public String type();

    public String etag();

    public Map<String, String> tags();

    public String displayName();

    public Boolean allowUpdates();

    public String defaultVersion();

    public String resourceGroupName();

    public ApplicationInner innerModel();

    public Update update();

    public Application refresh();

    public Application refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithDefaultVersion {
            public Update withDefaultVersion(String var1);
        }

        public static interface WithAllowUpdates {
            public Update withAllowUpdates(Boolean var1);
        }

        public static interface WithDisplayName {
            public Update withDisplayName(String var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithDisplayName,
    UpdateStages.WithAllowUpdates,
    UpdateStages.WithDefaultVersion {
        public Application apply();

        public Application apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithDefaultVersion {
            public WithCreate withDefaultVersion(String var1);
        }

        public static interface WithAllowUpdates {
            public WithCreate withAllowUpdates(Boolean var1);
        }

        public static interface WithDisplayName {
            public WithCreate withDisplayName(String var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithDisplayName,
        WithAllowUpdates,
        WithDefaultVersion {
            public Application create();

            public Application create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingBatchAccount(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

