/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ApplicationPackageReference
implements JsonSerializable<ApplicationPackageReference> {
    private String id;
    private String version;
    private static final ClientLogger LOGGER = new ClientLogger(ApplicationPackageReference.class);

    public String id() {
        return this.id;
    }

    public ApplicationPackageReference withId(String id) {
        this.id = id;
        return this;
    }

    public String version() {
        return this.version;
    }

    public ApplicationPackageReference withVersion(String version) {
        this.version = version;
        return this;
    }

    public void validate() {
        if (this.id() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property id in model ApplicationPackageReference"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("version", this.version);
        return jsonWriter.writeEndObject();
    }

    public static ApplicationPackageReference fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationPackageReference)jsonReader.readObject(reader -> {
            ApplicationPackageReference deserializedApplicationPackageReference = new ApplicationPackageReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedApplicationPackageReference.id = reader.getString();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedApplicationPackageReference.version = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationPackageReference;
        });
    }
}

