/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.AutoScaleRunError;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class AutoScaleRun
implements JsonSerializable<AutoScaleRun> {
    private OffsetDateTime evaluationTime;
    private String results;
    private AutoScaleRunError error;
    private static final ClientLogger LOGGER = new ClientLogger(AutoScaleRun.class);

    public OffsetDateTime evaluationTime() {
        return this.evaluationTime;
    }

    public AutoScaleRun withEvaluationTime(OffsetDateTime evaluationTime) {
        this.evaluationTime = evaluationTime;
        return this;
    }

    public String results() {
        return this.results;
    }

    public AutoScaleRun withResults(String results) {
        this.results = results;
        return this;
    }

    public AutoScaleRunError error() {
        return this.error;
    }

    public AutoScaleRun withError(AutoScaleRunError error) {
        this.error = error;
        return this;
    }

    public void validate() {
        if (this.evaluationTime() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property evaluationTime in model AutoScaleRun"));
        }
        if (this.error() != null) {
            this.error().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("evaluationTime", this.evaluationTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.evaluationTime));
        jsonWriter.writeStringField("results", this.results);
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        return jsonWriter.writeEndObject();
    }

    public static AutoScaleRun fromJson(JsonReader jsonReader) throws IOException {
        return (AutoScaleRun)jsonReader.readObject(reader -> {
            AutoScaleRun deserializedAutoScaleRun = new AutoScaleRun();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("evaluationTime".equals(fieldName)) {
                    deserializedAutoScaleRun.evaluationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("results".equals(fieldName)) {
                    deserializedAutoScaleRun.results = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedAutoScaleRun.error = AutoScaleRunError.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAutoScaleRun;
        });
    }
}

