/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class AutoScaleRunError
implements JsonSerializable<AutoScaleRunError> {
    private String code;
    private String message;
    private List<AutoScaleRunError> details;
    private static final ClientLogger LOGGER = new ClientLogger(AutoScaleRunError.class);

    public String code() {
        return this.code;
    }

    public AutoScaleRunError withCode(String code) {
        this.code = code;
        return this;
    }

    public String message() {
        return this.message;
    }

    public AutoScaleRunError withMessage(String message) {
        this.message = message;
        return this;
    }

    public List<AutoScaleRunError> details() {
        return this.details;
    }

    public AutoScaleRunError withDetails(List<AutoScaleRunError> details) {
        this.details = details;
        return this;
    }

    public void validate() {
        if (this.code() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property code in model AutoScaleRunError"));
        }
        if (this.message() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property message in model AutoScaleRunError"));
        }
        if (this.details() != null) {
            this.details().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeArrayField("details", this.details, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AutoScaleRunError fromJson(JsonReader jsonReader) throws IOException {
        return (AutoScaleRunError)jsonReader.readObject(reader -> {
            AutoScaleRunError deserializedAutoScaleRunError = new AutoScaleRunError();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    deserializedAutoScaleRunError.code = reader.getString();
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedAutoScaleRunError.message = reader.getString();
                    continue;
                }
                if ("details".equals(fieldName)) {
                    List details;
                    deserializedAutoScaleRunError.details = details = reader.readArray(reader1 -> AutoScaleRunError.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAutoScaleRunError;
        });
    }
}

