/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;

public final class AutoScaleSettings
implements JsonSerializable<AutoScaleSettings> {
    private String formula;
    private Duration evaluationInterval;
    private static final ClientLogger LOGGER = new ClientLogger(AutoScaleSettings.class);

    public String formula() {
        return this.formula;
    }

    public AutoScaleSettings withFormula(String formula) {
        this.formula = formula;
        return this;
    }

    public Duration evaluationInterval() {
        return this.evaluationInterval;
    }

    public AutoScaleSettings withEvaluationInterval(Duration evaluationInterval) {
        this.evaluationInterval = evaluationInterval;
        return this;
    }

    public void validate() {
        if (this.formula() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property formula in model AutoScaleSettings"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("formula", this.formula);
        jsonWriter.writeStringField("evaluationInterval", CoreUtils.durationToStringWithDays((Duration)this.evaluationInterval));
        return jsonWriter.writeEndObject();
    }

    public static AutoScaleSettings fromJson(JsonReader jsonReader) throws IOException {
        return (AutoScaleSettings)jsonReader.readObject(reader -> {
            AutoScaleSettings deserializedAutoScaleSettings = new AutoScaleSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("formula".equals(fieldName)) {
                    deserializedAutoScaleSettings.formula = reader.getString();
                    continue;
                }
                if ("evaluationInterval".equals(fieldName)) {
                    deserializedAutoScaleSettings.evaluationInterval = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAutoScaleSettings;
        });
    }
}

