/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.AutoStorageAuthenticationMode;
import com.azure.resourcemanager.batch.models.ComputeNodeIdentityReference;
import java.io.IOException;

public class AutoStorageBaseProperties
implements JsonSerializable<AutoStorageBaseProperties> {
    private String storageAccountId;
    private AutoStorageAuthenticationMode authenticationMode;
    private ComputeNodeIdentityReference nodeIdentityReference;
    private static final ClientLogger LOGGER = new ClientLogger(AutoStorageBaseProperties.class);

    public String storageAccountId() {
        return this.storageAccountId;
    }

    public AutoStorageBaseProperties withStorageAccountId(String storageAccountId) {
        this.storageAccountId = storageAccountId;
        return this;
    }

    public AutoStorageAuthenticationMode authenticationMode() {
        return this.authenticationMode;
    }

    public AutoStorageBaseProperties withAuthenticationMode(AutoStorageAuthenticationMode authenticationMode) {
        this.authenticationMode = authenticationMode;
        return this;
    }

    public ComputeNodeIdentityReference nodeIdentityReference() {
        return this.nodeIdentityReference;
    }

    public AutoStorageBaseProperties withNodeIdentityReference(ComputeNodeIdentityReference nodeIdentityReference) {
        this.nodeIdentityReference = nodeIdentityReference;
        return this;
    }

    public void validate() {
        if (this.storageAccountId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property storageAccountId in model AutoStorageBaseProperties"));
        }
        if (this.nodeIdentityReference() != null) {
            this.nodeIdentityReference().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageAccountId", this.storageAccountId);
        jsonWriter.writeStringField("authenticationMode", this.authenticationMode == null ? null : this.authenticationMode.toString());
        jsonWriter.writeJsonField("nodeIdentityReference", (JsonSerializable)this.nodeIdentityReference);
        return jsonWriter.writeEndObject();
    }

    public static AutoStorageBaseProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AutoStorageBaseProperties)jsonReader.readObject(reader -> {
            AutoStorageBaseProperties deserializedAutoStorageBaseProperties = new AutoStorageBaseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageAccountId".equals(fieldName)) {
                    deserializedAutoStorageBaseProperties.storageAccountId = reader.getString();
                    continue;
                }
                if ("authenticationMode".equals(fieldName)) {
                    deserializedAutoStorageBaseProperties.authenticationMode = AutoStorageAuthenticationMode.fromString(reader.getString());
                    continue;
                }
                if ("nodeIdentityReference".equals(fieldName)) {
                    deserializedAutoStorageBaseProperties.nodeIdentityReference = ComputeNodeIdentityReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAutoStorageBaseProperties;
        });
    }
}

