/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.AutoStorageAuthenticationMode;
import com.azure.resourcemanager.batch.models.AutoStorageBaseProperties;
import com.azure.resourcemanager.batch.models.ComputeNodeIdentityReference;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class AutoStorageProperties
extends AutoStorageBaseProperties {
    private OffsetDateTime lastKeySync;
    private static final ClientLogger LOGGER = new ClientLogger(AutoStorageProperties.class);

    public OffsetDateTime lastKeySync() {
        return this.lastKeySync;
    }

    public AutoStorageProperties withLastKeySync(OffsetDateTime lastKeySync) {
        this.lastKeySync = lastKeySync;
        return this;
    }

    @Override
    public AutoStorageProperties withStorageAccountId(String storageAccountId) {
        super.withStorageAccountId(storageAccountId);
        return this;
    }

    @Override
    public AutoStorageProperties withAuthenticationMode(AutoStorageAuthenticationMode authenticationMode) {
        super.withAuthenticationMode(authenticationMode);
        return this;
    }

    @Override
    public AutoStorageProperties withNodeIdentityReference(ComputeNodeIdentityReference nodeIdentityReference) {
        super.withNodeIdentityReference(nodeIdentityReference);
        return this;
    }

    @Override
    public void validate() {
        if (this.lastKeySync() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property lastKeySync in model AutoStorageProperties"));
        }
        if (this.storageAccountId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property storageAccountId in model AutoStorageProperties"));
        }
        if (this.nodeIdentityReference() != null) {
            this.nodeIdentityReference().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageAccountId", this.storageAccountId());
        jsonWriter.writeStringField("authenticationMode", this.authenticationMode() == null ? null : this.authenticationMode().toString());
        jsonWriter.writeJsonField("nodeIdentityReference", (JsonSerializable)this.nodeIdentityReference());
        jsonWriter.writeStringField("lastKeySync", this.lastKeySync == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastKeySync));
        return jsonWriter.writeEndObject();
    }

    public static AutoStorageProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AutoStorageProperties)jsonReader.readObject(reader -> {
            AutoStorageProperties deserializedAutoStorageProperties = new AutoStorageProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageAccountId".equals(fieldName)) {
                    deserializedAutoStorageProperties.withStorageAccountId(reader.getString());
                    continue;
                }
                if ("authenticationMode".equals(fieldName)) {
                    deserializedAutoStorageProperties.withAuthenticationMode(AutoStorageAuthenticationMode.fromString(reader.getString()));
                    continue;
                }
                if ("nodeIdentityReference".equals(fieldName)) {
                    deserializedAutoStorageProperties.withNodeIdentityReference(ComputeNodeIdentityReference.fromJson(reader));
                    continue;
                }
                if ("lastKeySync".equals(fieldName)) {
                    deserializedAutoStorageProperties.lastKeySync = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAutoStorageProperties;
        });
    }
}

