/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.ComputeNodeIdentityReference;
import java.io.IOException;

public final class AzureBlobFileSystemConfiguration
implements JsonSerializable<AzureBlobFileSystemConfiguration> {
    private String accountName;
    private String containerName;
    private String accountKey;
    private String sasKey;
    private String blobfuseOptions;
    private String relativeMountPath;
    private ComputeNodeIdentityReference identityReference;
    private static final ClientLogger LOGGER = new ClientLogger(AzureBlobFileSystemConfiguration.class);

    public String accountName() {
        return this.accountName;
    }

    public AzureBlobFileSystemConfiguration withAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    public String containerName() {
        return this.containerName;
    }

    public AzureBlobFileSystemConfiguration withContainerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    public String accountKey() {
        return this.accountKey;
    }

    public AzureBlobFileSystemConfiguration withAccountKey(String accountKey) {
        this.accountKey = accountKey;
        return this;
    }

    public String sasKey() {
        return this.sasKey;
    }

    public AzureBlobFileSystemConfiguration withSasKey(String sasKey) {
        this.sasKey = sasKey;
        return this;
    }

    public String blobfuseOptions() {
        return this.blobfuseOptions;
    }

    public AzureBlobFileSystemConfiguration withBlobfuseOptions(String blobfuseOptions) {
        this.blobfuseOptions = blobfuseOptions;
        return this;
    }

    public String relativeMountPath() {
        return this.relativeMountPath;
    }

    public AzureBlobFileSystemConfiguration withRelativeMountPath(String relativeMountPath) {
        this.relativeMountPath = relativeMountPath;
        return this;
    }

    public ComputeNodeIdentityReference identityReference() {
        return this.identityReference;
    }

    public AzureBlobFileSystemConfiguration withIdentityReference(ComputeNodeIdentityReference identityReference) {
        this.identityReference = identityReference;
        return this;
    }

    public void validate() {
        if (this.accountName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property accountName in model AzureBlobFileSystemConfiguration"));
        }
        if (this.containerName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property containerName in model AzureBlobFileSystemConfiguration"));
        }
        if (this.relativeMountPath() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property relativeMountPath in model AzureBlobFileSystemConfiguration"));
        }
        if (this.identityReference() != null) {
            this.identityReference().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("accountName", this.accountName);
        jsonWriter.writeStringField("containerName", this.containerName);
        jsonWriter.writeStringField("relativeMountPath", this.relativeMountPath);
        jsonWriter.writeStringField("accountKey", this.accountKey);
        jsonWriter.writeStringField("sasKey", this.sasKey);
        jsonWriter.writeStringField("blobfuseOptions", this.blobfuseOptions);
        jsonWriter.writeJsonField("identityReference", (JsonSerializable)this.identityReference);
        return jsonWriter.writeEndObject();
    }

    public static AzureBlobFileSystemConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (AzureBlobFileSystemConfiguration)jsonReader.readObject(reader -> {
            AzureBlobFileSystemConfiguration deserializedAzureBlobFileSystemConfiguration = new AzureBlobFileSystemConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("accountName".equals(fieldName)) {
                    deserializedAzureBlobFileSystemConfiguration.accountName = reader.getString();
                    continue;
                }
                if ("containerName".equals(fieldName)) {
                    deserializedAzureBlobFileSystemConfiguration.containerName = reader.getString();
                    continue;
                }
                if ("relativeMountPath".equals(fieldName)) {
                    deserializedAzureBlobFileSystemConfiguration.relativeMountPath = reader.getString();
                    continue;
                }
                if ("accountKey".equals(fieldName)) {
                    deserializedAzureBlobFileSystemConfiguration.accountKey = reader.getString();
                    continue;
                }
                if ("sasKey".equals(fieldName)) {
                    deserializedAzureBlobFileSystemConfiguration.sasKey = reader.getString();
                    continue;
                }
                if ("blobfuseOptions".equals(fieldName)) {
                    deserializedAzureBlobFileSystemConfiguration.blobfuseOptions = reader.getString();
                    continue;
                }
                if ("identityReference".equals(fieldName)) {
                    deserializedAzureBlobFileSystemConfiguration.identityReference = ComputeNodeIdentityReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureBlobFileSystemConfiguration;
        });
    }
}

