/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class AzureFileShareConfiguration
implements JsonSerializable<AzureFileShareConfiguration> {
    private String accountName;
    private String azureFileUrl;
    private String accountKey;
    private String relativeMountPath;
    private String mountOptions;
    private static final ClientLogger LOGGER = new ClientLogger(AzureFileShareConfiguration.class);

    public String accountName() {
        return this.accountName;
    }

    public AzureFileShareConfiguration withAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    public String azureFileUrl() {
        return this.azureFileUrl;
    }

    public AzureFileShareConfiguration withAzureFileUrl(String azureFileUrl) {
        this.azureFileUrl = azureFileUrl;
        return this;
    }

    public String accountKey() {
        return this.accountKey;
    }

    public AzureFileShareConfiguration withAccountKey(String accountKey) {
        this.accountKey = accountKey;
        return this;
    }

    public String relativeMountPath() {
        return this.relativeMountPath;
    }

    public AzureFileShareConfiguration withRelativeMountPath(String relativeMountPath) {
        this.relativeMountPath = relativeMountPath;
        return this;
    }

    public String mountOptions() {
        return this.mountOptions;
    }

    public AzureFileShareConfiguration withMountOptions(String mountOptions) {
        this.mountOptions = mountOptions;
        return this;
    }

    public void validate() {
        if (this.accountName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property accountName in model AzureFileShareConfiguration"));
        }
        if (this.azureFileUrl() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property azureFileUrl in model AzureFileShareConfiguration"));
        }
        if (this.accountKey() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property accountKey in model AzureFileShareConfiguration"));
        }
        if (this.relativeMountPath() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property relativeMountPath in model AzureFileShareConfiguration"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("accountName", this.accountName);
        jsonWriter.writeStringField("azureFileUrl", this.azureFileUrl);
        jsonWriter.writeStringField("accountKey", this.accountKey);
        jsonWriter.writeStringField("relativeMountPath", this.relativeMountPath);
        jsonWriter.writeStringField("mountOptions", this.mountOptions);
        return jsonWriter.writeEndObject();
    }

    public static AzureFileShareConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (AzureFileShareConfiguration)jsonReader.readObject(reader -> {
            AzureFileShareConfiguration deserializedAzureFileShareConfiguration = new AzureFileShareConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("accountName".equals(fieldName)) {
                    deserializedAzureFileShareConfiguration.accountName = reader.getString();
                    continue;
                }
                if ("azureFileUrl".equals(fieldName)) {
                    deserializedAzureFileShareConfiguration.azureFileUrl = reader.getString();
                    continue;
                }
                if ("accountKey".equals(fieldName)) {
                    deserializedAzureFileShareConfiguration.accountKey = reader.getString();
                    continue;
                }
                if ("relativeMountPath".equals(fieldName)) {
                    deserializedAzureFileShareConfiguration.relativeMountPath = reader.getString();
                    continue;
                }
                if ("mountOptions".equals(fieldName)) {
                    deserializedAzureFileShareConfiguration.mountOptions = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureFileShareConfiguration;
        });
    }
}

