/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.fluent.models.BatchAccountCreateProperties;
import com.azure.resourcemanager.batch.models.AuthenticationMode;
import com.azure.resourcemanager.batch.models.AutoStorageBaseProperties;
import com.azure.resourcemanager.batch.models.BatchAccountIdentity;
import com.azure.resourcemanager.batch.models.EncryptionProperties;
import com.azure.resourcemanager.batch.models.KeyVaultReference;
import com.azure.resourcemanager.batch.models.NetworkProfile;
import com.azure.resourcemanager.batch.models.PoolAllocationMode;
import com.azure.resourcemanager.batch.models.PublicNetworkAccessType;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class BatchAccountCreateParameters
implements JsonSerializable<BatchAccountCreateParameters> {
    private String location;
    private Map<String, String> tags;
    private BatchAccountCreateProperties innerProperties;
    private BatchAccountIdentity identity;
    private static final ClientLogger LOGGER = new ClientLogger(BatchAccountCreateParameters.class);

    public String location() {
        return this.location;
    }

    public BatchAccountCreateParameters withLocation(String location) {
        this.location = location;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public BatchAccountCreateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    private BatchAccountCreateProperties innerProperties() {
        return this.innerProperties;
    }

    public BatchAccountIdentity identity() {
        return this.identity;
    }

    public BatchAccountCreateParameters withIdentity(BatchAccountIdentity identity) {
        this.identity = identity;
        return this;
    }

    public AutoStorageBaseProperties autoStorage() {
        return this.innerProperties() == null ? null : this.innerProperties().autoStorage();
    }

    public BatchAccountCreateParameters withAutoStorage(AutoStorageBaseProperties autoStorage) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BatchAccountCreateProperties();
        }
        this.innerProperties().withAutoStorage(autoStorage);
        return this;
    }

    public PoolAllocationMode poolAllocationMode() {
        return this.innerProperties() == null ? null : this.innerProperties().poolAllocationMode();
    }

    public BatchAccountCreateParameters withPoolAllocationMode(PoolAllocationMode poolAllocationMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BatchAccountCreateProperties();
        }
        this.innerProperties().withPoolAllocationMode(poolAllocationMode);
        return this;
    }

    public KeyVaultReference keyVaultReference() {
        return this.innerProperties() == null ? null : this.innerProperties().keyVaultReference();
    }

    public BatchAccountCreateParameters withKeyVaultReference(KeyVaultReference keyVaultReference) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BatchAccountCreateProperties();
        }
        this.innerProperties().withKeyVaultReference(keyVaultReference);
        return this;
    }

    public PublicNetworkAccessType publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public BatchAccountCreateParameters withPublicNetworkAccess(PublicNetworkAccessType publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BatchAccountCreateProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public NetworkProfile networkProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().networkProfile();
    }

    public BatchAccountCreateParameters withNetworkProfile(NetworkProfile networkProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BatchAccountCreateProperties();
        }
        this.innerProperties().withNetworkProfile(networkProfile);
        return this;
    }

    public EncryptionProperties encryption() {
        return this.innerProperties() == null ? null : this.innerProperties().encryption();
    }

    public BatchAccountCreateParameters withEncryption(EncryptionProperties encryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BatchAccountCreateProperties();
        }
        this.innerProperties().withEncryption(encryption);
        return this;
    }

    public List<AuthenticationMode> allowedAuthenticationModes() {
        return this.innerProperties() == null ? null : this.innerProperties().allowedAuthenticationModes();
    }

    public BatchAccountCreateParameters withAllowedAuthenticationModes(List<AuthenticationMode> allowedAuthenticationModes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BatchAccountCreateProperties();
        }
        this.innerProperties().withAllowedAuthenticationModes(allowedAuthenticationModes);
        return this;
    }

    public void validate() {
        if (this.location() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property location in model BatchAccountCreateParameters"));
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static BatchAccountCreateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (BatchAccountCreateParameters)jsonReader.readObject(reader -> {
            BatchAccountCreateParameters deserializedBatchAccountCreateParameters = new BatchAccountCreateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("location".equals(fieldName)) {
                    deserializedBatchAccountCreateParameters.location = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedBatchAccountCreateParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedBatchAccountCreateParameters.innerProperties = BatchAccountCreateProperties.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedBatchAccountCreateParameters.identity = BatchAccountIdentity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBatchAccountCreateParameters;
        });
    }
}

