/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.fluent.models.BatchAccountInner;
import java.io.IOException;
import java.util.List;

public final class BatchAccountListResult
implements JsonSerializable<BatchAccountListResult> {
    private List<BatchAccountInner> value;
    private String nextLink;

    public List<BatchAccountInner> value() {
        return this.value;
    }

    public BatchAccountListResult withValue(List<BatchAccountInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public BatchAccountListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static BatchAccountListResult fromJson(JsonReader jsonReader) throws IOException {
        return (BatchAccountListResult)jsonReader.readObject(reader -> {
            BatchAccountListResult deserializedBatchAccountListResult = new BatchAccountListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedBatchAccountListResult.value = value = reader.readArray(reader1 -> BatchAccountInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedBatchAccountListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBatchAccountListResult;
        });
    }
}

